/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.netty.channel;

import com.baidu.cloud.thirdparty.asynchttpclient.AsyncHandler;
import com.baidu.cloud.thirdparty.asynchttpclient.Request;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.NettyResponseFuture;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.SimpleFutureListener;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.ChannelManager;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.ChannelState;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.Channels;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.ConnectionSemaphore;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.future.StackTraceInspector;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.request.NettyRequestSender;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.timeout.TimeoutsHolder;
import com.baidu.cloud.thirdparty.asynchttpclient.proxy.ProxyServer;
import com.baidu.cloud.thirdparty.asynchttpclient.uri.Uri;
import com.baidu.cloud.thirdparty.netty.channel.Channel;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpRequest;
import com.baidu.cloud.thirdparty.netty.handler.ssl.SslHandler;
import com.baidu.cloud.thirdparty.netty.util.concurrent.Future;
import com.baidu.cloud.thirdparty.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyConnectListener<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyConnectListener.class);
    private final NettyRequestSender requestSender;
    private final NettyResponseFuture<T> future;
    private final ChannelManager channelManager;
    private final ConnectionSemaphore connectionSemaphore;

    public NettyConnectListener(NettyResponseFuture<T> future, NettyRequestSender requestSender, ChannelManager channelManager, ConnectionSemaphore connectionSemaphore) {
        this.future = future;
        this.requestSender = requestSender;
        this.channelManager = channelManager;
        this.connectionSemaphore = connectionSemaphore;
    }

    private boolean futureIsAlreadyCancelled(Channel channel) {
        if (this.future.isDone()) {
            Channels.silentlyCloseChannel(channel);
            return true;
        }
        return false;
    }

    private void writeRequest(Channel channel) {
        if (this.futureIsAlreadyCancelled(channel)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            HttpRequest httpRequest = this.future.getNettyRequest().getHttpRequest();
            LOGGER.debug("Using new Channel '{}' for '{}' to '{}'", new Object[]{channel, httpRequest.method(), httpRequest.uri()});
        }
        Channels.setAttribute(channel, this.future);
        this.channelManager.registerOpenChannel(channel);
        this.future.attachChannel(channel, false);
        this.requestSender.writeRequest(this.future, channel);
    }

    public void onSuccess(final Channel channel, InetSocketAddress remoteAddress) {
        Object partitionKeyLock;
        if (this.connectionSemaphore != null && (partitionKeyLock = this.future.takePartitionKeyLock()) != null) {
            channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.connectionSemaphore.releaseChannelLock(partitionKeyLock)));
        }
        Channels.setActiveToken(channel);
        TimeoutsHolder timeoutsHolder = this.future.getTimeoutsHolder();
        if (this.futureIsAlreadyCancelled(channel)) {
            return;
        }
        Request request = this.future.getTargetRequest();
        Uri uri = request.getUri();
        timeoutsHolder.setResolvedRemoteAddress(remoteAddress);
        ProxyServer proxyServer = this.future.getProxyServer();
        if ((proxyServer == null || proxyServer.getProxyType().isSocks()) && uri.isSecured()) {
            SslHandler sslHandler;
            try {
                sslHandler = this.channelManager.addSslHandler(channel.pipeline(), uri, request.getVirtualHost(), proxyServer != null);
            }
            catch (Exception sslError) {
                this.onFailure(channel, sslError);
                return;
            }
            final AsyncHandler<T> asyncHandler = this.future.getAsyncHandler();
            try {
                asyncHandler.onTlsHandshakeAttempt();
            }
            catch (Exception e) {
                LOGGER.error("onTlsHandshakeAttempt crashed", (Throwable)e);
                this.onFailure(channel, e);
                return;
            }
            sslHandler.handshakeFuture().addListener((GenericFutureListener<Future<Channel>>)new SimpleFutureListener<Channel>(){

                @Override
                protected void onSuccess(Channel value) {
                    try {
                        asyncHandler.onTlsHandshakeSuccess(sslHandler.engine().getSession());
                    }
                    catch (Exception e) {
                        LOGGER.error("onTlsHandshakeSuccess crashed", (Throwable)e);
                        NettyConnectListener.this.onFailure(channel, e);
                        return;
                    }
                    NettyConnectListener.this.writeRequest(channel);
                }

                @Override
                protected void onFailure(Throwable cause) {
                    try {
                        asyncHandler.onTlsHandshakeFailure(cause);
                    }
                    catch (Exception e) {
                        LOGGER.error("onTlsHandshakeFailure crashed", (Throwable)e);
                        NettyConnectListener.this.onFailure(channel, e);
                        return;
                    }
                    NettyConnectListener.this.onFailure(channel, cause);
                }
            });
        } else {
            this.writeRequest(channel);
        }
    }

    public void onFailure(Channel channel, Throwable cause) {
        Channels.silentlyCloseChannel(channel);
        boolean canRetry = this.future.incrementRetryAndCheck();
        LOGGER.debug("Trying to recover from failing to connect channel {} with a retry value of {} ", (Object)channel, (Object)canRetry);
        if (canRetry && cause != null && (this.future.getChannelState() != ChannelState.NEW || StackTraceInspector.recoverOnNettyDisconnectException(cause)) && this.requestSender.retry(this.future)) {
            return;
        }
        LOGGER.debug("Failed to recover from connect exception: {} with channel {}", (Object)cause, (Object)channel);
        String message = cause.getMessage() != null ? cause.getMessage() : this.future.getUri().getBaseUrl();
        ConnectException e = new ConnectException(message);
        e.initCause(cause);
        this.future.abort(e);
    }
}

