/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.netty.handler.intercept;

import com.baidu.cloud.thirdparty.asynchttpclient.AsyncHttpClientConfig;
import com.baidu.cloud.thirdparty.asynchttpclient.Realm;
import com.baidu.cloud.thirdparty.asynchttpclient.Request;
import com.baidu.cloud.thirdparty.asynchttpclient.RequestBuilder;
import com.baidu.cloud.thirdparty.asynchttpclient.cookie.CookieStore;
import com.baidu.cloud.thirdparty.asynchttpclient.handler.MaxRedirectException;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.NettyResponseFuture;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.ChannelManager;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.request.NettyRequestSender;
import com.baidu.cloud.thirdparty.asynchttpclient.uri.Uri;
import com.baidu.cloud.thirdparty.asynchttpclient.util.HttpConstants;
import com.baidu.cloud.thirdparty.asynchttpclient.util.HttpUtils;
import com.baidu.cloud.thirdparty.asynchttpclient.util.MiscUtils;
import com.baidu.cloud.thirdparty.asynchttpclient.util.ThrowableUtil;
import com.baidu.cloud.thirdparty.netty.channel.Channel;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpHeaderNames;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpHeaders;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpResponse;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpUtil;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.cookie.Cookie;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Redirect30xInterceptor {
    public static final Set<Integer> REDIRECT_STATUSES = new HashSet<Integer>();
    private static final Logger LOGGER = LoggerFactory.getLogger(Redirect30xInterceptor.class);
    private final ChannelManager channelManager;
    private final AsyncHttpClientConfig config;
    private final NettyRequestSender requestSender;
    private final MaxRedirectException maxRedirectException;

    Redirect30xInterceptor(ChannelManager channelManager, AsyncHttpClientConfig config, NettyRequestSender requestSender) {
        this.channelManager = channelManager;
        this.config = config;
        this.requestSender = requestSender;
        this.maxRedirectException = ThrowableUtil.unknownStackTrace(new MaxRedirectException("Maximum redirect reached: " + config.getMaxRedirects()), Redirect30xInterceptor.class, "exitAfterHandlingRedirect");
    }

    public boolean exitAfterHandlingRedirect(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm) throws Exception {
        if (HttpUtils.followRedirect(this.config, request)) {
            boolean sameBase;
            List<Cookie> cookies;
            if (future.incrementAndGetCurrentRedirectCount() >= this.config.getMaxRedirects()) {
                throw this.maxRedirectException;
            }
            future.setInAuth(false);
            future.setInProxyAuth(false);
            String originalMethod = request.getMethod();
            boolean switchToGet = !originalMethod.equals(HttpConstants.Methods.GET) && (statusCode == HttpConstants.ResponseStatusCodes.MOVED_PERMANENTLY_301 || statusCode == HttpConstants.ResponseStatusCodes.SEE_OTHER_303 || statusCode == HttpConstants.ResponseStatusCodes.FOUND_302 && !this.config.isStrict302Handling());
            boolean keepBody = statusCode == HttpConstants.ResponseStatusCodes.TEMPORARY_REDIRECT_307 || statusCode == HttpConstants.ResponseStatusCodes.PERMANENT_REDIRECT_308 || statusCode == HttpConstants.ResponseStatusCodes.FOUND_302 && this.config.isStrict302Handling();
            RequestBuilder requestBuilder = (RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder(switchToGet ? HttpConstants.Methods.GET : originalMethod).setChannelPoolPartitioning(request.getChannelPoolPartitioning())).setFollowRedirect(true)).setLocalAddress(request.getLocalAddress())).setNameResolver(request.getNameResolver())).setProxyServer(request.getProxyServer())).setRealm(request.getRealm())).setRequestTimeout(request.getRequestTimeout());
            if (keepBody) {
                requestBuilder.setCharset(request.getCharset());
                if (MiscUtils.isNonEmpty(request.getFormParams())) {
                    requestBuilder.setFormParams(request.getFormParams());
                } else if (request.getStringData() != null) {
                    requestBuilder.setBody(request.getStringData());
                } else if (request.getByteData() != null) {
                    requestBuilder.setBody(request.getByteData());
                } else if (request.getByteBufferData() != null) {
                    requestBuilder.setBody(request.getByteBufferData());
                } else if (request.getBodyGenerator() != null) {
                    requestBuilder.setBody(request.getBodyGenerator());
                } else if (MiscUtils.isNonEmpty(request.getBodyParts())) {
                    requestBuilder.setBodyParts(request.getBodyParts());
                }
            }
            requestBuilder.setHeaders(this.propagatedHeaders(request, realm, keepBody));
            boolean initialConnectionKeepAlive = future.isKeepAlive();
            Object initialPartitionKey = future.getPartitionKey();
            HttpHeaders responseHeaders = response.headers();
            String location = responseHeaders.get(HttpHeaderNames.LOCATION);
            Uri newUri = Uri.create(future.getUri(), location);
            LOGGER.debug("Redirecting to {}", (Object)newUri);
            CookieStore cookieStore = this.config.getCookieStore();
            if (cookieStore != null && !(cookies = cookieStore.get(newUri)).isEmpty()) {
                for (Cookie cookie : cookies) {
                    requestBuilder.addOrReplaceCookie(cookie);
                }
            }
            if (sameBase = request.getUri().isSameBase(newUri)) {
                requestBuilder.setVirtualHost(request.getVirtualHost());
            }
            Request nextRequest = ((RequestBuilder)requestBuilder.setUri(newUri)).build();
            future.setTargetRequest(nextRequest);
            LOGGER.debug("Sending redirect to {}", (Object)newUri);
            if (future.isKeepAlive() && !HttpUtil.isTransferEncodingChunked(response)) {
                if (sameBase) {
                    future.setReuseChannel(true);
                    this.requestSender.drainChannelAndExecuteNextRequest(channel, future, nextRequest);
                } else {
                    this.channelManager.drainChannelAndOffer(channel, future, initialConnectionKeepAlive, initialPartitionKey);
                    this.requestSender.sendNextRequest(nextRequest, future);
                }
            } else {
                this.channelManager.closeChannel(channel);
                this.requestSender.sendNextRequest(nextRequest, future);
            }
            return true;
        }
        return false;
    }

    private HttpHeaders propagatedHeaders(Request request, Realm realm, boolean keepBody) {
        HttpHeaders headers = request.getHeaders().remove(HttpHeaderNames.HOST).remove(HttpHeaderNames.CONTENT_LENGTH);
        if (!keepBody) {
            headers.remove(HttpHeaderNames.CONTENT_TYPE);
        }
        if (realm != null && realm.getScheme() == Realm.AuthScheme.NTLM) {
            headers.remove(HttpHeaderNames.AUTHORIZATION).remove(HttpHeaderNames.PROXY_AUTHORIZATION);
        }
        return headers;
    }

    static {
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.MOVED_PERMANENTLY_301);
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.FOUND_302);
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.SEE_OTHER_303);
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.TEMPORARY_REDIRECT_307);
        REDIRECT_STATUSES.add(HttpConstants.ResponseStatusCodes.PERMANENT_REDIRECT_308);
    }
}

