/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.netty.handler.intercept;

import com.baidu.cloud.thirdparty.asynchttpclient.AsyncHandler;
import com.baidu.cloud.thirdparty.asynchttpclient.AsyncHttpClientConfig;
import com.baidu.cloud.thirdparty.asynchttpclient.HttpResponseStatus;
import com.baidu.cloud.thirdparty.asynchttpclient.filter.FilterContext;
import com.baidu.cloud.thirdparty.asynchttpclient.filter.FilterException;
import com.baidu.cloud.thirdparty.asynchttpclient.filter.ResponseFilter;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.NettyResponseFuture;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.request.NettyRequestSender;
import com.baidu.cloud.thirdparty.asynchttpclient.util.Assertions;
import com.baidu.cloud.thirdparty.netty.channel.Channel;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpHeaders;

public class ResponseFiltersInterceptor {
    private final AsyncHttpClientConfig config;
    private final NettyRequestSender requestSender;

    ResponseFiltersInterceptor(AsyncHttpClientConfig config, NettyRequestSender requestSender) {
        this.config = config;
        this.requestSender = requestSender;
    }

    public boolean exitAfterProcessingFilters(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponseStatus status, HttpHeaders responseHeaders) {
        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(future.getCurrentRequest()).responseStatus(status).responseHeaders(responseHeaders).build();
        for (ResponseFilter asyncFilter : this.config.getResponseFilters()) {
            try {
                fc = asyncFilter.filter(fc);
                Assertions.assertNotNull("fc", "filterContext");
            }
            catch (FilterException fe) {
                this.requestSender.abort(channel, future, fe);
            }
        }
        future.setAsyncHandler(fc.getAsyncHandler());
        if (fc.replayRequest()) {
            this.requestSender.replayRequest(future, fc, channel);
            return true;
        }
        return false;
    }
}

