/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.netty.request.body;

import com.baidu.cloud.thirdparty.asynchttpclient.AsyncHttpClientConfig;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.NettyResponseFuture;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.ChannelManager;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.request.WriteProgressListener;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.request.body.NettyBody;
import com.baidu.cloud.thirdparty.netty.channel.Channel;
import com.baidu.cloud.thirdparty.netty.channel.DefaultFileRegion;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.LastHttpContent;
import com.baidu.cloud.thirdparty.netty.handler.stream.ChunkedNioFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class NettyFileBody
implements NettyBody {
    private final File file;
    private final long offset;
    private final long length;
    private final AsyncHttpClientConfig config;

    public NettyFileBody(File file, AsyncHttpClientConfig config) {
        this(file, 0L, file.length(), config);
    }

    public NettyFileBody(File file, long offset, long length, AsyncHttpClientConfig config) {
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.format("File %s is not a file or doesn't exist", file.getAbsolutePath()));
        }
        this.file = file;
        this.offset = offset;
        this.length = length;
        this.config = config;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) throws IOException {
        FileChannel fileChannel = new RandomAccessFile(this.file, "r").getChannel();
        boolean noZeroCopy = ChannelManager.isSslHandlerConfigured(channel.pipeline()) || this.config.isDisableZeroCopy();
        Object body = noZeroCopy ? new ChunkedNioFile(fileChannel, this.offset, this.length, this.config.getChunkedFileChunkSize()) : new DefaultFileRegion(fileChannel, this.offset, this.length);
        channel.write(body, channel.newProgressivePromise()).addListener(new WriteProgressListener(future, false, this.length));
        channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT, channel.voidPromise());
    }
}

