/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.netty.ssl;

import com.baidu.cloud.thirdparty.asynchttpclient.AsyncHttpClientConfig;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.ssl.SslEngineFactoryBase;
import com.baidu.cloud.thirdparty.asynchttpclient.util.MiscUtils;
import com.baidu.cloud.thirdparty.netty.buffer.ByteBufAllocator;
import com.baidu.cloud.thirdparty.netty.handler.ssl.IdentityCipherSuiteFilter;
import com.baidu.cloud.thirdparty.netty.handler.ssl.SslContext;
import com.baidu.cloud.thirdparty.netty.handler.ssl.SslContextBuilder;
import com.baidu.cloud.thirdparty.netty.handler.ssl.SslProvider;
import com.baidu.cloud.thirdparty.netty.handler.ssl.util.InsecureTrustManagerFactory;
import com.baidu.cloud.thirdparty.netty.util.ReferenceCountUtil;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

public class DefaultSslEngineFactory
extends SslEngineFactoryBase {
    private volatile SslContext sslContext;

    private SslContext buildSslContext(AsyncHttpClientConfig config) throws SSLException {
        if (config.getSslContext() != null) {
            return config.getSslContext();
        }
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(config.isUseOpenSsl() ? SslProvider.OPENSSL : SslProvider.JDK).sessionCacheSize(config.getSslSessionCacheSize()).sessionTimeout(config.getSslSessionTimeout());
        if (MiscUtils.isNonEmpty(config.getEnabledProtocols())) {
            sslContextBuilder.protocols(config.getEnabledProtocols());
        }
        if (MiscUtils.isNonEmpty(config.getEnabledCipherSuites())) {
            sslContextBuilder.ciphers(Arrays.asList(config.getEnabledCipherSuites()));
        } else if (!config.isFilterInsecureCipherSuites()) {
            sslContextBuilder.ciphers(null, IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS);
        }
        if (config.isUseInsecureTrustManager()) {
            sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        return this.configureSslContextBuilder(sslContextBuilder).build();
    }

    @Override
    public SSLEngine newSslEngine(AsyncHttpClientConfig config, String peerHost, int peerPort) {
        SSLEngine sslEngine = config.isDisableHttpsEndpointIdentificationAlgorithm() ? this.sslContext.newEngine(ByteBufAllocator.DEFAULT) : this.sslContext.newEngine(ByteBufAllocator.DEFAULT, this.domain(peerHost), peerPort);
        this.configureSslEngine(sslEngine, config);
        return sslEngine;
    }

    @Override
    public void init(AsyncHttpClientConfig config) throws SSLException {
        this.sslContext = this.buildSslContext(config);
    }

    @Override
    public void destroy() {
        ReferenceCountUtil.release(this.sslContext);
    }

    protected SslContextBuilder configureSslContextBuilder(SslContextBuilder builder) {
        return builder;
    }
}

