/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.netty.timeout;

import com.baidu.cloud.thirdparty.asynchttpclient.netty.NettyResponseFuture;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.request.NettyRequestSender;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.timeout.TimeoutTimerTask;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.timeout.TimeoutsHolder;
import com.baidu.cloud.thirdparty.asynchttpclient.util.DateUtils;
import com.baidu.cloud.thirdparty.asynchttpclient.util.StringBuilderPool;
import com.baidu.cloud.thirdparty.netty.util.Timeout;

public class ReadTimeoutTimerTask
extends TimeoutTimerTask {
    private final long readTimeout;

    ReadTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder, int readTimeout) {
        super(nettyResponseFuture, requestSender, timeoutsHolder);
        this.readTimeout = readTimeout;
    }

    @Override
    public void run(Timeout timeout) {
        if (this.done.getAndSet(true) || this.requestSender.isClosed()) {
            return;
        }
        if (this.nettyResponseFuture.isDone()) {
            this.timeoutsHolder.cancel();
            return;
        }
        long now = DateUtils.unpreciseMillisTime();
        long currentReadTimeoutInstant = this.readTimeout + this.nettyResponseFuture.getLastTouch();
        long durationBeforeCurrentReadTimeout = currentReadTimeoutInstant - now;
        if (durationBeforeCurrentReadTimeout <= 0L) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder().append("Read timeout to ");
            this.appendRemoteAddress(sb);
            String message = sb.append(" after ").append(this.readTimeout).append(" ms").toString();
            long durationSinceLastTouch = now - this.nettyResponseFuture.getLastTouch();
            this.expire(message, durationSinceLastTouch);
            this.timeoutsHolder.cancel();
        } else {
            this.done.set(false);
            this.timeoutsHolder.startReadTimeout(this);
        }
    }
}

