/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.netty.timeout;

import com.baidu.cloud.thirdparty.asynchttpclient.AsyncHttpClientConfig;
import com.baidu.cloud.thirdparty.asynchttpclient.Request;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.NettyResponseFuture;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.request.NettyRequestSender;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.timeout.ReadTimeoutTimerTask;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.timeout.RequestTimeoutTimerTask;
import com.baidu.cloud.thirdparty.asynchttpclient.util.DateUtils;
import com.baidu.cloud.thirdparty.netty.util.Timeout;
import com.baidu.cloud.thirdparty.netty.util.Timer;
import com.baidu.cloud.thirdparty.netty.util.TimerTask;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TimeoutsHolder {
    private final Timeout requestTimeout;
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final Timer nettyTimer;
    private final NettyRequestSender requestSender;
    private final long requestTimeoutMillisTime;
    private final int readTimeoutValue;
    private volatile Timeout readTimeout;
    private volatile NettyResponseFuture<?> nettyResponseFuture;
    private volatile InetSocketAddress remoteAddress;

    public TimeoutsHolder(Timer nettyTimer, NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, AsyncHttpClientConfig config, InetSocketAddress originalRemoteAddress) {
        this.nettyTimer = nettyTimer;
        this.nettyResponseFuture = nettyResponseFuture;
        this.requestSender = requestSender;
        this.remoteAddress = originalRemoteAddress;
        Request targetRequest = nettyResponseFuture.getTargetRequest();
        int readTimeoutInMs = targetRequest.getReadTimeout();
        this.readTimeoutValue = readTimeoutInMs == 0 ? config.getReadTimeout() : readTimeoutInMs;
        int requestTimeoutInMs = targetRequest.getRequestTimeout();
        if (requestTimeoutInMs == 0) {
            requestTimeoutInMs = config.getRequestTimeout();
        }
        if (requestTimeoutInMs != -1) {
            this.requestTimeoutMillisTime = DateUtils.unpreciseMillisTime() + (long)requestTimeoutInMs;
            this.requestTimeout = this.newTimeout(new RequestTimeoutTimerTask(nettyResponseFuture, requestSender, this, requestTimeoutInMs), requestTimeoutInMs);
        } else {
            this.requestTimeoutMillisTime = -1L;
            this.requestTimeout = null;
        }
    }

    public void setResolvedRemoteAddress(InetSocketAddress address) {
        this.remoteAddress = address;
    }

    InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public void startReadTimeout() {
        if (this.readTimeoutValue != -1) {
            this.startReadTimeout(null);
        }
    }

    void startReadTimeout(ReadTimeoutTimerTask task) {
        if (this.requestTimeout == null || !this.requestTimeout.isExpired() && (long)this.readTimeoutValue < this.requestTimeoutMillisTime - DateUtils.unpreciseMillisTime()) {
            if (task == null) {
                task = new ReadTimeoutTimerTask(this.nettyResponseFuture, this.requestSender, this, this.readTimeoutValue);
            }
            this.readTimeout = this.newTimeout(task, this.readTimeoutValue);
        } else if (task != null) {
            task.clean();
        }
    }

    public void cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            if (this.requestTimeout != null) {
                this.requestTimeout.cancel();
                ((RequestTimeoutTimerTask)RequestTimeoutTimerTask.class.cast(this.requestTimeout.task())).clean();
            }
            if (this.readTimeout != null) {
                this.readTimeout.cancel();
                ((ReadTimeoutTimerTask)ReadTimeoutTimerTask.class.cast(this.readTimeout.task())).clean();
            }
        }
    }

    private Timeout newTimeout(TimerTask task, long delay) {
        return this.requestSender.isClosed() ? null : this.nettyTimer.newTimeout(task, delay, TimeUnit.MILLISECONDS);
    }
}

