/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.request.body.multipart;

import com.baidu.cloud.thirdparty.asynchttpclient.request.body.multipart.ByteArrayPart;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.multipart.FilePart;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.multipart.InputStreamPart;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.multipart.MultipartBody;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.multipart.Part;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.multipart.StringPart;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.multipart.part.ByteArrayMultipartPart;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.multipart.part.FileMultipartPart;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.multipart.part.InputStreamMultipartPart;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.multipart.part.MessageEndMultipartPart;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.multipart.part.MultipartPart;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.multipart.part.StringMultipartPart;
import com.baidu.cloud.thirdparty.asynchttpclient.util.Assertions;
import com.baidu.cloud.thirdparty.asynchttpclient.util.HttpUtils;
import com.baidu.cloud.thirdparty.asynchttpclient.util.MiscUtils;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpHeaderNames;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpHeaderValues;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpHeaders;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class MultipartUtils {
    public static MultipartBody newMultipartBody(List<Part> parts, HttpHeaders requestHeaders) {
        byte[] boundary;
        String contentType;
        Assertions.assertNotNull(parts, "parts");
        String contentTypeHeader = requestHeaders.get(HttpHeaderNames.CONTENT_TYPE);
        if (MiscUtils.isNonEmpty(contentTypeHeader)) {
            int boundaryLocation = contentTypeHeader.indexOf("boundary=");
            if (boundaryLocation != -1) {
                contentType = contentTypeHeader;
                boundary = contentTypeHeader.substring(boundaryLocation + "boundary=".length()).trim().getBytes(StandardCharsets.US_ASCII);
            } else {
                boundary = HttpUtils.computeMultipartBoundary();
                contentType = HttpUtils.patchContentTypeWithBoundaryAttribute(contentTypeHeader, boundary);
            }
        } else {
            boundary = HttpUtils.computeMultipartBoundary();
            contentType = HttpUtils.patchContentTypeWithBoundaryAttribute(HttpHeaderValues.MULTIPART_FORM_DATA, boundary);
        }
        List<MultipartPart<? extends Part>> multipartParts = MultipartUtils.generateMultipartParts(parts, boundary);
        return new MultipartBody(multipartParts, contentType, boundary);
    }

    public static List<MultipartPart<? extends Part>> generateMultipartParts(List<Part> parts, byte[] boundary) {
        ArrayList<MultipartPart<? extends Part>> multipartParts = new ArrayList<MultipartPart<? extends Part>>(parts.size());
        for (Part part : parts) {
            if (part instanceof FilePart) {
                multipartParts.add(new FileMultipartPart((FilePart)part, boundary));
                continue;
            }
            if (part instanceof ByteArrayPart) {
                multipartParts.add(new ByteArrayMultipartPart((ByteArrayPart)part, boundary));
                continue;
            }
            if (part instanceof StringPart) {
                multipartParts.add(new StringMultipartPart((StringPart)part, boundary));
                continue;
            }
            if (part instanceof InputStreamPart) {
                multipartParts.add(new InputStreamMultipartPart((InputStreamPart)part, boundary));
                continue;
            }
            throw new IllegalArgumentException("Unknown part type: " + part);
        }
        multipartParts.add(new MessageEndMultipartPart(boundary));
        return multipartParts;
    }
}

