/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.util;

import com.baidu.cloud.thirdparty.asynchttpclient.AsyncHttpClientConfig;
import com.baidu.cloud.thirdparty.asynchttpclient.Dsl;
import com.baidu.cloud.thirdparty.asynchttpclient.Realm;
import com.baidu.cloud.thirdparty.asynchttpclient.Request;
import com.baidu.cloud.thirdparty.asynchttpclient.proxy.ProxyServer;
import com.baidu.cloud.thirdparty.asynchttpclient.proxy.ProxyServerSelector;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyUtils {
    public static final String PROXY_HOST = "http.proxyHost";
    public static final String PROXY_PORT = "http.proxyPort";
    public static final String PROXY_NONPROXYHOSTS = "http.nonProxyHosts";
    private static final Logger logger = LoggerFactory.getLogger(ProxyUtils.class);
    private static final String PROPERTY_PREFIX = "com.baidu.cloud.thirdparty.asynchttpclient.AsyncHttpClientConfig.proxy.";
    private static final String PROXY_USER = "com.baidu.cloud.thirdparty.asynchttpclient.AsyncHttpClientConfig.proxy.user";
    private static final String PROXY_PASSWORD = "com.baidu.cloud.thirdparty.asynchttpclient.AsyncHttpClientConfig.proxy.password";

    private ProxyUtils() {
    }

    public static ProxyServer getProxyServer(AsyncHttpClientConfig config, Request request) {
        ProxyServerSelector selector;
        ProxyServer proxyServer = request.getProxyServer();
        if (proxyServer == null && (selector = config.getProxyServerSelector()) != null) {
            proxyServer = selector.select(request.getUri());
        }
        return proxyServer != null && !proxyServer.isIgnoredForHost(request.getUri().getHost()) ? proxyServer : null;
    }

    public static ProxyServerSelector createProxyServerSelector(Properties properties) {
        String host = properties.getProperty(PROXY_HOST);
        if (host != null) {
            int port = Integer.valueOf(properties.getProperty(PROXY_PORT, "80"));
            String principal = properties.getProperty(PROXY_USER);
            String password = properties.getProperty(PROXY_PASSWORD);
            Realm realm = null;
            if (principal != null) {
                realm = Dsl.basicAuthRealm(principal, password).build();
            }
            ProxyServer.Builder proxyServer = Dsl.proxyServer(host, port).setRealm(realm);
            String nonProxyHosts = properties.getProperty(PROXY_NONPROXYHOSTS);
            if (nonProxyHosts != null) {
                proxyServer.setNonProxyHosts(new ArrayList<String>(Arrays.asList(nonProxyHosts.split("\\|"))));
            }
            ProxyServer proxy = proxyServer.build();
            return uri -> proxy;
        }
        return ProxyServerSelector.NO_PROXY_SELECTOR;
    }

    public static ProxyServerSelector getJdkDefaultProxyServerSelector() {
        return ProxyUtils.createProxyServerSelector(ProxySelector.getDefault());
    }

    private static ProxyServerSelector createProxyServerSelector(ProxySelector proxySelector) {
        return uri -> {
            try {
                URI javaUri = uri.toJavaNetURI();
                List<Proxy> proxies = proxySelector.select(javaUri);
                if (proxies != null) {
                    for (Proxy proxy : proxies) {
                        switch (proxy.type()) {
                            case HTTP: {
                                if (!(proxy.address() instanceof InetSocketAddress)) {
                                    logger.warn("Don't know how to connect to address " + proxy.address());
                                    return null;
                                }
                                InetSocketAddress address = (InetSocketAddress)proxy.address();
                                return Dsl.proxyServer(address.getHostString(), address.getPort()).build();
                            }
                            case DIRECT: {
                                return null;
                            }
                        }
                        logger.warn("ProxySelector returned proxy type that we don't know how to use: " + (Object)((Object)proxy.type()));
                    }
                }
                return null;
            }
            catch (URISyntaxException e) {
                logger.warn(uri + " couldn't be turned into a java.net.URI", (Throwable)e);
                return null;
            }
        };
    }
}

