/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.dyuprotostuff;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public final class LinkedBuffer {
    public static final int MIN_BUFFER_SIZE = 256;
    public static final int DEFAULT_BUFFER_SIZE = 512;
    final byte[] buffer;
    final int start;
    int offset;
    LinkedBuffer next;

    public static LinkedBuffer allocate(int size) {
        if (size < 256) {
            throw new IllegalArgumentException("256 is the minimum buffer size.");
        }
        return new LinkedBuffer(size);
    }

    public static LinkedBuffer allocate(int size, LinkedBuffer previous) {
        if (size < 256) {
            throw new IllegalArgumentException("256 is the minimum buffer size.");
        }
        return new LinkedBuffer(size, previous);
    }

    public static LinkedBuffer wrap(byte[] array, int offset, int length) {
        return new LinkedBuffer(array, offset, offset + length);
    }

    public static LinkedBuffer use(byte[] buffer) {
        return LinkedBuffer.use(buffer, 0);
    }

    public static LinkedBuffer use(byte[] buffer, int start) {
        assert (start >= 0);
        if (buffer.length - start < 256) {
            throw new IllegalArgumentException("256 is the minimum buffer size.");
        }
        return new LinkedBuffer(buffer, start, start);
    }

    public static int writeTo(OutputStream out, LinkedBuffer node) throws IOException {
        int contentSize = 0;
        do {
            int len;
            if ((len = node.offset - node.start) <= 0) continue;
            out.write(node.buffer, node.start, len);
            contentSize += len;
        } while ((node = node.next) != null);
        return contentSize;
    }

    public static int writeTo(DataOutput out, LinkedBuffer node) throws IOException {
        int contentSize = 0;
        do {
            int len;
            if ((len = node.offset - node.start) <= 0) continue;
            out.write(node.buffer, node.start, len);
            contentSize += len;
        } while ((node = node.next) != null);
        return contentSize;
    }

    LinkedBuffer(int size) {
        this(new byte[size], 0, 0);
    }

    LinkedBuffer(int size, LinkedBuffer appendTarget) {
        this(new byte[size], 0, 0, appendTarget);
    }

    LinkedBuffer(byte[] buffer, int offset) {
        this(buffer, offset, offset);
    }

    LinkedBuffer(byte[] buffer, int start, int offset) {
        this.buffer = buffer;
        this.start = start;
        this.offset = offset;
    }

    LinkedBuffer(byte[] buffer, int offset, LinkedBuffer appendTarget) {
        this(buffer, offset, offset);
        appendTarget.next = this;
    }

    LinkedBuffer(byte[] buffer, int start, int offset, LinkedBuffer appendTarget) {
        this(buffer, start, offset);
        appendTarget.next = this;
    }

    LinkedBuffer(LinkedBuffer viewSource, LinkedBuffer appendTarget) {
        this.buffer = viewSource.buffer;
        this.offset = this.start = viewSource.offset;
        appendTarget.next = this;
    }

    public LinkedBuffer clear() {
        this.next = null;
        this.offset = this.start;
        return this;
    }
}

