/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.protostuff;

import com.baidu.cloud.thirdparty.protostuff.ByteString;
import com.baidu.cloud.thirdparty.protostuff.Input;
import com.baidu.cloud.thirdparty.protostuff.Output;
import com.baidu.cloud.thirdparty.protostuff.ProtobufException;
import com.baidu.cloud.thirdparty.protostuff.Schema;
import com.baidu.cloud.thirdparty.protostuff.StringSerializer;
import com.baidu.cloud.thirdparty.protostuff.UninitializedMessageException;
import com.baidu.cloud.thirdparty.protostuff.WireFormat;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class ByteBufferInput
implements Input {
    private final ByteBuffer buffer;
    private int lastTag = 0;
    private int packedLimit = 0;
    public final boolean decodeNestedMessageAsGroup;

    public ByteBufferInput(ByteBuffer buffer, boolean protostuffMessage) {
        this.buffer = buffer.slice();
        this.decodeNestedMessageAsGroup = protostuffMessage;
    }

    public ByteBufferInput reset(int offset, int len) {
        this.buffer.rewind();
        return this;
    }

    public int currentOffset() {
        return this.buffer.position();
    }

    public int currentLimit() {
        return this.buffer.limit();
    }

    public boolean isCurrentFieldPacked() {
        return this.packedLimit != 0 && this.packedLimit != this.buffer.position();
    }

    public int getLastTag() {
        return this.lastTag;
    }

    public int readTag() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.lastTag = 0;
            return 0;
        }
        int tag = this.readRawVarint32();
        if (tag >>> 3 == 0) {
            throw ProtobufException.invalidTag();
        }
        this.lastTag = tag;
        return tag;
    }

    public void checkLastTagWas(int value) throws ProtobufException {
        if (this.lastTag != value) {
            throw ProtobufException.invalidEndTag();
        }
    }

    public boolean skipField(int tag) throws IOException {
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                this.readInt32();
                return true;
            }
            case 1: {
                this.readRawLittleEndian64();
                return true;
            }
            case 2: {
                int size = this.readRawVarint32();
                if (size < 0) {
                    throw ProtobufException.negativeSize();
                }
                this.buffer.position(this.buffer.position() + size);
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.readRawLittleEndian32();
                return true;
            }
        }
        throw ProtobufException.invalidWireType();
    }

    public void skipMessage() throws IOException {
        int tag;
        while ((tag = this.readTag()) != 0 && this.skipField(tag)) {
        }
    }

    @Override
    public <T> void handleUnknownField(int fieldNumber, Schema<T> schema) throws IOException {
        this.skipField(this.lastTag);
    }

    @Override
    public <T> int readFieldNumber(Schema<T> schema) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.lastTag = 0;
            return 0;
        }
        if (this.isCurrentFieldPacked()) {
            if (this.packedLimit < this.buffer.position()) {
                throw ProtobufException.misreportedSize();
            }
            return this.lastTag >>> 3;
        }
        this.packedLimit = 0;
        int tag = this.readRawVarint32();
        int fieldNumber = tag >>> 3;
        if (fieldNumber == 0) {
            if (this.decodeNestedMessageAsGroup && 7 == (tag & 7)) {
                this.lastTag = 0;
                return 0;
            }
            throw ProtobufException.invalidTag();
        }
        if (this.decodeNestedMessageAsGroup && 4 == (tag & 7)) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = tag;
        return fieldNumber;
    }

    private void checkIfPackedField() throws IOException {
        if (this.packedLimit == 0 && WireFormat.getTagWireType(this.lastTag) == 2) {
            int length = this.readRawVarint32();
            if (length < 0) {
                throw ProtobufException.negativeSize();
            }
            if (this.buffer.position() + length > this.buffer.limit()) {
                throw ProtobufException.misreportedSize();
            }
            this.packedLimit = this.buffer.position() + length;
        }
    }

    @Override
    public double readDouble() throws IOException {
        this.checkIfPackedField();
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    @Override
    public float readFloat() throws IOException {
        this.checkIfPackedField();
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    @Override
    public long readUInt64() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint64();
    }

    @Override
    public long readInt64() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint64();
    }

    @Override
    public int readInt32() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint32();
    }

    @Override
    public long readFixed64() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian64();
    }

    @Override
    public int readFixed32() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian32();
    }

    @Override
    public boolean readBool() throws IOException {
        this.checkIfPackedField();
        return this.buffer.get() != 0;
    }

    @Override
    public int readUInt32() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint32();
    }

    @Override
    public int readEnum() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint32();
    }

    @Override
    public int readSFixed32() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian32();
    }

    @Override
    public long readSFixed64() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian64();
    }

    @Override
    public int readSInt32() throws IOException {
        this.checkIfPackedField();
        int n = this.readRawVarint32();
        return n >>> 1 ^ -(n & 1);
    }

    @Override
    public long readSInt64() throws IOException {
        this.checkIfPackedField();
        long n = this.readRawVarint64();
        return n >>> 1 ^ -(n & 1L);
    }

    @Override
    public String readString() throws IOException {
        int length = this.readRawVarint32();
        if (length < 0) {
            throw ProtobufException.negativeSize();
        }
        if (this.buffer.remaining() < length) {
            throw ProtobufException.misreportedSize();
        }
        if (this.buffer.hasArray()) {
            int currPosition = this.buffer.position();
            this.buffer.position(this.buffer.position() + length);
            return StringSerializer.STRING.deser(this.buffer.array(), this.buffer.arrayOffset() + currPosition, length);
        }
        byte[] tmp = new byte[length];
        this.buffer.get(tmp);
        return StringSerializer.STRING.deser(tmp);
    }

    @Override
    public ByteString readBytes() throws IOException {
        return ByteString.wrap(this.readByteArray());
    }

    @Override
    public void readBytes(ByteBuffer bb) throws IOException {
        int length = this.readRawVarint32();
        if (length < 0) {
            throw ProtobufException.negativeSize();
        }
        if (this.buffer.remaining() < length) {
            throw ProtobufException.misreportedSize();
        }
        bb.put(this.buffer);
    }

    @Override
    public byte[] readByteArray() throws IOException {
        int length = this.readRawVarint32();
        if (length < 0) {
            throw ProtobufException.negativeSize();
        }
        if (this.buffer.remaining() < length) {
            throw ProtobufException.misreportedSize();
        }
        byte[] copy = new byte[length];
        this.buffer.get(copy);
        return copy;
    }

    @Override
    public <T> T mergeObject(T value, Schema<T> schema) throws IOException {
        if (this.decodeNestedMessageAsGroup) {
            return this.mergeObjectEncodedAsGroup(value, schema);
        }
        int length = this.readRawVarint32();
        if (length < 0) {
            throw ProtobufException.negativeSize();
        }
        if (this.buffer.remaining() < length) {
            throw ProtobufException.misreportedSize();
        }
        ByteBuffer dup = this.buffer.slice();
        dup.limit(length);
        if (value == null) {
            value = schema.newMessage();
        }
        ByteBufferInput nestedInput = new ByteBufferInput(dup, this.decodeNestedMessageAsGroup);
        schema.mergeFrom(nestedInput, value);
        if (!schema.isInitialized(value)) {
            throw new UninitializedMessageException(value, schema);
        }
        nestedInput.checkLastTagWas(0);
        this.buffer.position(this.buffer.position() + length);
        return value;
    }

    private <T> T mergeObjectEncodedAsGroup(T value, Schema<T> schema) throws IOException {
        if (value == null) {
            value = schema.newMessage();
        }
        schema.mergeFrom(this, value);
        if (!schema.isInitialized(value)) {
            throw new UninitializedMessageException(value, schema);
        }
        this.checkLastTagWas(0);
        return value;
    }

    public int readRawVarint32() throws IOException {
        byte tmp = this.buffer.get();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = this.buffer.get();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = this.buffer.get();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = this.buffer.get();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = this.buffer.get();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.buffer.get() < 0) continue;
                            return result;
                        }
                        throw ProtobufException.malformedVarint();
                    }
                }
            }
        }
        return result;
    }

    public long readRawVarint64() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.buffer.get();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw ProtobufException.malformedVarint();
    }

    public int readRawLittleEndian32() throws IOException {
        byte[] bs = new byte[4];
        this.buffer.get(bs);
        return bs[0] & 0xFF | (bs[1] & 0xFF) << 8 | (bs[2] & 0xFF) << 16 | (bs[3] & 0xFF) << 24;
    }

    public long readRawLittleEndian64() throws IOException {
        byte[] bs = new byte[8];
        this.buffer.get(bs);
        return (long)bs[0] & 0xFFL | ((long)bs[1] & 0xFFL) << 8 | ((long)bs[2] & 0xFFL) << 16 | ((long)bs[3] & 0xFFL) << 24 | ((long)bs[4] & 0xFFL) << 32 | ((long)bs[5] & 0xFFL) << 40 | ((long)bs[6] & 0xFFL) << 48 | ((long)bs[7] & 0xFFL) << 56;
    }

    @Override
    public void transferByteRangeTo(Output output, boolean utf8String, int fieldNumber, boolean repeated) throws IOException {
        int length = this.readRawVarint32();
        if (length < 0) {
            throw ProtobufException.negativeSize();
        }
        if (utf8String) {
            if (this.buffer.hasArray()) {
                output.writeByteRange(true, fieldNumber, this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), length, repeated);
                this.buffer.position(this.buffer.position() + length);
            } else {
                byte[] bytes = new byte[length];
                this.buffer.get(bytes);
                output.writeByteRange(true, fieldNumber, bytes, 0, bytes.length, repeated);
            }
        } else {
            if (this.buffer.remaining() < length) {
                throw ProtobufException.misreportedSize();
            }
            ByteBuffer dup = this.buffer.slice();
            dup.limit(length);
            output.writeBytes(fieldNumber, dup, repeated);
            this.buffer.position(this.buffer.position() + length);
        }
    }

    @Override
    public ByteBuffer readByteBuffer() throws IOException {
        return ByteBuffer.wrap(this.readByteArray());
    }
}

