/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.protostuff;

import com.baidu.cloud.thirdparty.protostuff.ByteString;
import com.baidu.cloud.thirdparty.protostuff.Input;
import com.baidu.cloud.thirdparty.protostuff.Output;
import com.baidu.cloud.thirdparty.protostuff.ProtobufException;
import com.baidu.cloud.thirdparty.protostuff.Schema;
import com.baidu.cloud.thirdparty.protostuff.StringSerializer;
import com.baidu.cloud.thirdparty.protostuff.UninitializedMessageException;
import com.baidu.cloud.thirdparty.protostuff.WireFormat;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class CodedInput
implements Input {
    private final byte[] buffer;
    private int bufferSize;
    private int bufferSizeAfterLimit;
    private int bufferPos;
    private final InputStream input;
    private int lastTag;
    private int packedLimit = 0;
    private int totalBytesRetired;
    private int currentLimit = Integer.MAX_VALUE;
    public final boolean decodeNestedMessageAsGroup;
    private int sizeLimit = 0x4000000;
    static final int DEFAULT_SIZE_LIMIT = 0x4000000;
    static final int DEFAULT_BUFFER_SIZE = 4096;

    public static CodedInput newInstance(InputStream input) {
        return new CodedInput(input, false);
    }

    public static CodedInput newInstance(byte[] buf) {
        return CodedInput.newInstance(buf, 0, buf.length);
    }

    public static CodedInput newInstance(byte[] buf, int off, int len) {
        return new CodedInput(buf, off, len, false);
    }

    public int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        int tag = this.readRawVarint32();
        if (tag >>> 3 == 0) {
            throw ProtobufException.invalidTag();
        }
        this.lastTag = tag;
        return tag;
    }

    public void checkLastTagWas(int value) throws ProtobufException {
        if (this.lastTag != value) {
            throw ProtobufException.invalidEndTag();
        }
    }

    public boolean skipField(int tag) throws IOException {
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                this.readInt32();
                return true;
            }
            case 1: {
                this.readRawLittleEndian64();
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readRawVarint32());
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.readRawLittleEndian32();
                return true;
            }
        }
        throw ProtobufException.invalidWireType();
    }

    public void skipMessage() throws IOException {
        int tag;
        while ((tag = this.readTag()) != 0 && this.skipField(tag)) {
        }
    }

    @Override
    public double readDouble() throws IOException {
        this.checkIfPackedField();
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    @Override
    public float readFloat() throws IOException {
        this.checkIfPackedField();
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    @Override
    public long readUInt64() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint64();
    }

    @Override
    public long readInt64() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint64();
    }

    @Override
    public int readInt32() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint32();
    }

    @Override
    public long readFixed64() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian64();
    }

    @Override
    public int readFixed32() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian32();
    }

    @Override
    public boolean readBool() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint32() != 0;
    }

    @Override
    public String readString() throws IOException {
        int size = this.readRawVarint32();
        if (size <= this.bufferSize - this.bufferPos && size > 0) {
            String result = StringSerializer.STRING.deser(this.buffer, this.bufferPos, size);
            this.bufferPos += size;
            return result;
        }
        return StringSerializer.STRING.deser(this.readRawBytes(size));
    }

    @Override
    public void readBytes(ByteBuffer bb) throws IOException {
        int size = this.readRawVarint32();
        if (size <= this.bufferSize - this.bufferPos && size > 0) {
            bb.limit(size);
            bb.put(this.buffer, this.bufferPos, size);
            this.bufferPos += size;
        } else {
            bb.put(this.readRawBytes(size));
        }
    }

    @Override
    public <T> T mergeObject(T value, Schema<T> schema) throws IOException {
        if (this.decodeNestedMessageAsGroup) {
            return this.mergeObjectEncodedAsGroup(value, schema);
        }
        int length = this.readRawVarint32();
        int oldLimit = this.pushLimit(length);
        if (value == null) {
            value = schema.newMessage();
        }
        schema.mergeFrom(this, value);
        if (!schema.isInitialized(value)) {
            throw new UninitializedMessageException(value, schema);
        }
        this.checkLastTagWas(0);
        this.popLimit(oldLimit);
        return value;
    }

    private <T> T mergeObjectEncodedAsGroup(T value, Schema<T> schema) throws IOException {
        if (value == null) {
            value = schema.newMessage();
        }
        schema.mergeFrom(this, value);
        if (!schema.isInitialized(value)) {
            throw new UninitializedMessageException(value, schema);
        }
        this.checkLastTagWas(0);
        return value;
    }

    @Override
    public ByteString readBytes() throws IOException {
        int size = this.readRawVarint32();
        if (size == 0) {
            return ByteString.EMPTY;
        }
        if (size <= this.bufferSize - this.bufferPos && size > 0) {
            ByteString result = ByteString.copyFrom(this.buffer, this.bufferPos, size);
            this.bufferPos += size;
            return result;
        }
        return ByteString.wrap(this.readRawBytes(size));
    }

    @Override
    public int readUInt32() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint32();
    }

    @Override
    public int readEnum() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarint32();
    }

    @Override
    public int readSFixed32() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian32();
    }

    @Override
    public long readSFixed64() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian64();
    }

    @Override
    public int readSInt32() throws IOException {
        this.checkIfPackedField();
        return CodedInput.decodeZigZag32(this.readRawVarint32());
    }

    @Override
    public long readSInt64() throws IOException {
        this.checkIfPackedField();
        return CodedInput.decodeZigZag64(this.readRawVarint64());
    }

    public int readRawVarint32() throws IOException {
        byte tmp = this.readRawByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = this.readRawByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = this.readRawByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = this.readRawByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = this.readRawByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.readRawByte() < 0) continue;
                            return result;
                        }
                        throw ProtobufException.malformedVarint();
                    }
                }
            }
        }
        return result;
    }

    static int readRawVarint32(InputStream input) throws IOException {
        int firstByte = input.read();
        if (firstByte == -1) {
            throw ProtobufException.truncatedMessage();
        }
        if ((firstByte & 0x80) == 0) {
            return firstByte;
        }
        return CodedInput.readRawVarint32(input, firstByte);
    }

    static int readRawVarint32(InputStream input, int firstByte) throws IOException {
        int b;
        int offset;
        int result = firstByte & 0x7F;
        for (offset = 7; offset < 32; offset += 7) {
            b = input.read();
            if (b == -1) {
                throw ProtobufException.truncatedMessage();
            }
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        while (offset < 64) {
            b = input.read();
            if (b == -1) {
                throw ProtobufException.truncatedMessage();
            }
            if ((b & 0x80) == 0) {
                return result;
            }
            offset += 7;
        }
        throw ProtobufException.malformedVarint();
    }

    static int readRawVarint32(DataInput input, byte firstByte) throws IOException {
        byte b;
        int offset;
        int result = firstByte & 0x7F;
        for (offset = 7; offset < 32; offset += 7) {
            b = input.readByte();
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        while (offset < 64) {
            b = input.readByte();
            if ((b & 0x80) == 0) {
                return result;
            }
            offset += 7;
        }
        throw ProtobufException.malformedVarint();
    }

    public long readRawVarint64() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw ProtobufException.malformedVarint();
    }

    public int readRawLittleEndian32() throws IOException {
        byte b1 = this.readRawByte();
        byte b2 = this.readRawByte();
        byte b3 = this.readRawByte();
        byte b4 = this.readRawByte();
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    public long readRawLittleEndian64() throws IOException {
        byte b1 = this.readRawByte();
        byte b2 = this.readRawByte();
        byte b3 = this.readRawByte();
        byte b4 = this.readRawByte();
        byte b5 = this.readRawByte();
        byte b6 = this.readRawByte();
        byte b7 = this.readRawByte();
        byte b8 = this.readRawByte();
        return (long)b1 & 0xFFL | ((long)b2 & 0xFFL) << 8 | ((long)b3 & 0xFFL) << 16 | ((long)b4 & 0xFFL) << 24 | ((long)b5 & 0xFFL) << 32 | ((long)b6 & 0xFFL) << 40 | ((long)b7 & 0xFFL) << 48 | ((long)b8 & 0xFFL) << 56;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public CodedInput(byte[] buffer, int off, int len, boolean decodeNestedMessageAsGroup) {
        this.buffer = buffer;
        this.bufferSize = off + len;
        this.bufferPos = off;
        this.totalBytesRetired = -off;
        this.input = null;
        this.decodeNestedMessageAsGroup = decodeNestedMessageAsGroup;
    }

    public CodedInput(InputStream input, boolean decodeNestedMessageAsGroup) {
        this(input, new byte[4096], 0, 0, decodeNestedMessageAsGroup);
    }

    public CodedInput(InputStream input, byte[] buffer, boolean decodeNestedMessageAsGroup) {
        this(input, buffer, 0, 0, decodeNestedMessageAsGroup);
    }

    public CodedInput(InputStream input, byte[] buffer, int offset, int limit, boolean decodeNestedMessageAsGroup) {
        this.buffer = buffer;
        this.bufferSize = limit;
        this.bufferPos = offset;
        this.totalBytesRetired = -offset;
        this.input = input;
        this.decodeNestedMessageAsGroup = decodeNestedMessageAsGroup;
    }

    public int setSizeLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Size limit cannot be negative: " + limit);
        }
        int oldLimit = this.sizeLimit;
        this.sizeLimit = limit;
        return oldLimit;
    }

    public void resetSizeCounter() {
        this.totalBytesRetired = -this.bufferPos;
    }

    public void reset() {
        this.bufferSize = 0;
        this.bufferPos = 0;
        this.bufferSizeAfterLimit = 0;
        this.currentLimit = Integer.MAX_VALUE;
        this.lastTag = 0;
        this.packedLimit = 0;
        this.sizeLimit = 0x4000000;
        this.resetSizeCounter();
    }

    public int pushLimit(int byteLimit) throws ProtobufException {
        if (byteLimit < 0) {
            throw ProtobufException.negativeSize();
        }
        int oldLimit = this.currentLimit;
        if ((byteLimit += this.totalBytesRetired + this.bufferPos) > oldLimit) {
            throw ProtobufException.truncatedMessage();
        }
        this.currentLimit = byteLimit;
        this.recomputeBufferSizeAfterLimit();
        return oldLimit;
    }

    private void recomputeBufferSizeAfterLimit() {
        this.bufferSize += this.bufferSizeAfterLimit;
        int bufferEnd = this.totalBytesRetired + this.bufferSize;
        if (bufferEnd > this.currentLimit) {
            this.bufferSizeAfterLimit = bufferEnd - this.currentLimit;
            this.bufferSize -= this.bufferSizeAfterLimit;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    public void popLimit(int oldLimit) {
        this.currentLimit = oldLimit;
        this.recomputeBufferSizeAfterLimit();
    }

    public int getBytesUntilLimit() {
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        int currentAbsolutePosition = this.totalBytesRetired + this.bufferPos;
        return this.currentLimit - currentAbsolutePosition;
    }

    public boolean isCurrentFieldPacked() {
        return this.packedLimit != 0 && this.packedLimit != this.getTotalBytesRead();
    }

    public boolean isAtEnd() throws IOException {
        return this.bufferPos == this.bufferSize && !this.refillBuffer(false);
    }

    public int getTotalBytesRead() {
        return this.totalBytesRetired + this.bufferPos;
    }

    private boolean refillBuffer(boolean mustSucceed) throws IOException {
        if (this.bufferPos < this.bufferSize) {
            throw new IllegalStateException("refillBuffer() called when buffer wasn't empty.");
        }
        if (this.totalBytesRetired + this.bufferSize == this.currentLimit) {
            if (mustSucceed) {
                throw ProtobufException.truncatedMessage();
            }
            return false;
        }
        this.totalBytesRetired += this.bufferSize;
        this.bufferPos = 0;
        int n = this.bufferSize = this.input == null ? -1 : this.input.read(this.buffer);
        if (this.bufferSize == 0 || this.bufferSize < -1) {
            throw new IllegalStateException("InputStream#read(byte[]) returned invalid result: " + this.bufferSize + "\nThe InputStream implementation is buggy.");
        }
        if (this.bufferSize == -1) {
            this.bufferSize = 0;
            if (mustSucceed) {
                throw ProtobufException.truncatedMessage();
            }
            return false;
        }
        this.recomputeBufferSizeAfterLimit();
        int totalBytesRead = this.totalBytesRetired + this.bufferSize + this.bufferSizeAfterLimit;
        if (totalBytesRead > this.sizeLimit || totalBytesRead < 0) {
            throw ProtobufException.sizeLimitExceeded();
        }
        return true;
    }

    public byte readRawByte() throws IOException {
        if (this.bufferPos == this.bufferSize) {
            this.refillBuffer(true);
        }
        return this.buffer[this.bufferPos++];
    }

    public byte[] readRawBytes(int size) throws IOException {
        int pos;
        byte[] chunk;
        if (size < 0) {
            throw ProtobufException.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + size > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw ProtobufException.truncatedMessage();
        }
        if (size <= this.bufferSize - this.bufferPos) {
            byte[] bytes = new byte[size];
            System.arraycopy(this.buffer, this.bufferPos, bytes, 0, size);
            this.bufferPos += size;
            return bytes;
        }
        if (size < this.buffer.length) {
            byte[] bytes = new byte[size];
            int pos2 = this.bufferSize - this.bufferPos;
            System.arraycopy(this.buffer, this.bufferPos, bytes, 0, pos2);
            this.bufferPos = this.bufferSize;
            this.refillBuffer(true);
            while (size - pos2 > this.bufferSize) {
                System.arraycopy(this.buffer, 0, bytes, pos2, this.bufferSize);
                pos2 += this.bufferSize;
                this.bufferPos = this.bufferSize;
                this.refillBuffer(true);
            }
            System.arraycopy(this.buffer, 0, bytes, pos2, size - pos2);
            this.bufferPos = size - pos2;
            return bytes;
        }
        int originalBufferPos = this.bufferPos;
        int originalBufferSize = this.bufferSize;
        this.totalBytesRetired += this.bufferSize;
        this.bufferPos = 0;
        this.bufferSize = 0;
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        for (int sizeLeft = size - (originalBufferSize - originalBufferPos); sizeLeft > 0; sizeLeft -= chunk.length) {
            int n;
            chunk = new byte[Math.min(sizeLeft, this.buffer.length)];
            for (pos = 0; pos < chunk.length; pos += n) {
                int n2 = n = this.input == null ? -1 : this.input.read(chunk, pos, chunk.length - pos);
                if (n == -1) {
                    throw ProtobufException.truncatedMessage();
                }
                this.totalBytesRetired += n;
            }
            chunks.add(chunk);
        }
        byte[] bytes = new byte[size];
        pos = originalBufferSize - originalBufferPos;
        System.arraycopy(this.buffer, originalBufferPos, bytes, 0, pos);
        for (byte[] chunk2 : chunks) {
            System.arraycopy(chunk2, 0, bytes, pos, chunk2.length);
            pos += chunk2.length;
        }
        return bytes;
    }

    public void skipRawBytes(int size) throws IOException {
        if (size < 0) {
            throw ProtobufException.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + size > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw ProtobufException.truncatedMessage();
        }
        if (size <= this.bufferSize - this.bufferPos) {
            this.bufferPos += size;
        } else {
            int pos = this.bufferSize - this.bufferPos;
            this.bufferPos = this.bufferSize;
            this.refillBuffer(true);
            while (size - pos > this.bufferSize) {
                pos += this.bufferSize;
                this.bufferPos = this.bufferSize;
                this.refillBuffer(true);
            }
            this.bufferPos = size - pos;
        }
    }

    @Override
    public <T> int readFieldNumber(Schema<T> schema) throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        if (this.isCurrentFieldPacked()) {
            if (this.packedLimit < this.getTotalBytesRead()) {
                throw ProtobufException.misreportedSize();
            }
            return this.lastTag >>> 3;
        }
        this.packedLimit = 0;
        int tag = this.readRawVarint32();
        int fieldNumber = tag >>> 3;
        if (fieldNumber == 0) {
            if (this.decodeNestedMessageAsGroup && 7 == (tag & 7)) {
                this.lastTag = 0;
                return 0;
            }
            throw ProtobufException.invalidTag();
        }
        if (this.decodeNestedMessageAsGroup && 4 == (tag & 7)) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = tag;
        return fieldNumber;
    }

    private void checkIfPackedField() throws IOException {
        if (this.packedLimit == 0 && WireFormat.getTagWireType(this.lastTag) == 2) {
            int length = this.readRawVarint32();
            if (length < 0) {
                throw ProtobufException.negativeSize();
            }
            this.packedLimit = this.getTotalBytesRead() + length;
        }
    }

    @Override
    public byte[] readByteArray() throws IOException {
        int size = this.readRawVarint32();
        if (size <= this.bufferSize - this.bufferPos && size > 0) {
            byte[] copy = new byte[size];
            System.arraycopy(this.buffer, this.bufferPos, copy, 0, size);
            this.bufferPos += size;
            return copy;
        }
        return this.readRawBytes(size);
    }

    @Override
    public <T> void handleUnknownField(int fieldNumber, Schema<T> schema) throws IOException {
        this.skipField(this.lastTag);
    }

    @Override
    public void transferByteRangeTo(Output output, boolean utf8String, int fieldNumber, boolean repeated) throws IOException {
        int size = this.readRawVarint32();
        if (size <= this.bufferSize - this.bufferPos && size > 0) {
            output.writeByteRange(utf8String, fieldNumber, this.buffer, this.bufferPos, size, repeated);
            this.bufferPos += size;
        } else {
            output.writeByteRange(utf8String, fieldNumber, this.readRawBytes(size), 0, size, repeated);
        }
    }

    public int getLastTag() {
        return this.lastTag;
    }

    @Override
    public ByteBuffer readByteBuffer() throws IOException {
        return ByteBuffer.wrap(this.readByteArray());
    }
}

