/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.protostuff;

import com.baidu.cloud.thirdparty.protostuff.LinkedBuffer;
import com.baidu.cloud.thirdparty.protostuff.WriteSink;
import java.io.IOException;
import java.io.OutputStream;

public class WriteSession {
    public final LinkedBuffer head;
    protected LinkedBuffer tail;
    protected int size = 0;
    public final int nextBufferSize;
    public final OutputStream out;
    public final FlushHandler flushHandler;
    public final WriteSink sink;

    public WriteSession(LinkedBuffer head) {
        this(head, 512);
    }

    public WriteSession(LinkedBuffer head, int nextBufferSize) {
        this.tail = head;
        this.head = head;
        this.nextBufferSize = nextBufferSize;
        this.out = null;
        this.flushHandler = null;
        this.sink = WriteSink.BUFFERED;
    }

    public WriteSession(LinkedBuffer head, OutputStream out, FlushHandler flushHandler, int nextBufferSize) {
        this.tail = head;
        this.head = head;
        this.nextBufferSize = nextBufferSize;
        this.out = out;
        this.flushHandler = flushHandler;
        this.sink = WriteSink.STREAMED;
        assert (out != null);
    }

    public WriteSession(LinkedBuffer head, OutputStream out) {
        this(head, out, null, 512);
    }

    public void reset() {
    }

    public WriteSession clear() {
        this.tail = this.head.clear();
        this.size = 0;
        return this;
    }

    public final int getSize() {
        return this.size;
    }

    public final byte[] toByteArray() {
        LinkedBuffer node = this.head;
        int offset = 0;
        byte[] buf = new byte[this.size];
        do {
            int len;
            if ((len = node.offset - node.start) <= 0) continue;
            System.arraycopy(node.buffer, node.start, buf, offset, len);
            offset += len;
        } while ((node = node.next) != null);
        return buf;
    }

    protected int flush(byte[] buf, int offset, int len) throws IOException {
        if (this.flushHandler != null) {
            return this.flushHandler.flush(this, buf, offset, len);
        }
        this.out.write(buf, offset, len);
        return offset;
    }

    protected int flush(byte[] buf, int offset, int len, byte[] next, int nextoffset, int nextlen) throws IOException {
        if (this.flushHandler != null) {
            return this.flushHandler.flush(this, buf, offset, len, next, nextoffset, nextlen);
        }
        this.out.write(buf, offset, len);
        this.out.write(next, nextoffset, nextlen);
        return offset;
    }

    protected int flush(LinkedBuffer lb, byte[] buf, int offset, int len) throws IOException {
        if (this.flushHandler != null) {
            return this.flushHandler.flush(this, lb, buf, offset, len);
        }
        this.out.write(buf, offset, len);
        return lb.start;
    }

    public static interface FlushHandler {
        public int flush(WriteSession var1, byte[] var2, int var3, int var4) throws IOException;

        public int flush(WriteSession var1, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7) throws IOException;

        public int flush(WriteSession var1, LinkedBuffer var2, byte[] var3, int var4, int var5) throws IOException;
    }
}

