/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.protostuff.runtime;

import com.baidu.cloud.thirdparty.protostuff.CollectionSchema;
import com.baidu.cloud.thirdparty.protostuff.Input;
import com.baidu.cloud.thirdparty.protostuff.MapSchema;
import com.baidu.cloud.thirdparty.protostuff.Output;
import com.baidu.cloud.thirdparty.protostuff.Pipe;
import com.baidu.cloud.thirdparty.protostuff.Tag;
import com.baidu.cloud.thirdparty.protostuff.runtime.ArraySchemas;
import com.baidu.cloud.thirdparty.protostuff.runtime.IdStrategy;
import com.baidu.cloud.thirdparty.protostuff.runtime.PolymorphicSchema;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public abstract class EnumIO<E extends Enum<E>>
implements PolymorphicSchema.Factory {
    private static final Field __keyTypeFromEnumMap;
    private static final Field __elementTypeFromEnumSet;
    public final Class<E> enumClass;
    public final IdStrategy strategy;
    public final ArraySchemas.Base genericElementSchema;
    private volatile CollectionSchema.MessageFactory enumSetFactory;
    private volatile MapSchema.MessageFactory enumMapFactory;
    private final String[] alias;
    private final int[] tag;
    private final Map<String, E> valueByAliasMap;
    private final Map<Integer, E> valueByTagMap;

    static Class<?> getKeyTypeFromEnumMap(Object enumMap) {
        if (__keyTypeFromEnumMap == null) {
            throw new RuntimeException("Could not access (reflection) the private field *keyType* (enumClass) from: class java.util.EnumMap");
        }
        try {
            return (Class)__keyTypeFromEnumMap.get(enumMap);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static Class<?> getElementTypeFromEnumSet(Object enumSet) {
        if (__elementTypeFromEnumSet == null) {
            throw new RuntimeException("Could not access (reflection) the private field *elementType* (enumClass) from: class java.util.EnumSet");
        }
        try {
            return (Class)__elementTypeFromEnumSet.get(enumSet);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static EnumIO<? extends Enum<?>> newEnumIO(Class<?> enumClass, IdStrategy strategy) {
        return 0 == (1 & strategy.flags) ? new ByNumber(enumClass, strategy) : new ByName(enumClass, strategy);
    }

    public void writeTo(Output output, int number, boolean repeated, Enum<?> e) throws IOException {
        if (0 == (1 & this.strategy.flags)) {
            output.writeEnum(number, this.getTag(e), repeated);
        } else {
            output.writeString(number, this.getAlias(e), repeated);
        }
    }

    public static void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated, IdStrategy strategy) throws IOException {
        if (0 == (1 & strategy.flags)) {
            output.writeEnum(number, input.readEnum(), repeated);
        } else {
            input.transferByteRangeTo(output, true, number, repeated);
        }
    }

    private static <E extends Enum<E>> CollectionSchema.MessageFactory newEnumSetFactory(final EnumIO<E> eio) {
        return new CollectionSchema.MessageFactory(){

            @Override
            public <V> Collection<V> newMessage() {
                return eio.newEnumSet();
            }

            @Override
            public Class<?> typeClass() {
                return EnumSet.class;
            }
        };
    }

    private static <E extends Enum<E>> MapSchema.MessageFactory newEnumMapFactory(final EnumIO<E> eio) {
        return new MapSchema.MessageFactory(){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return eio.newEnumMap();
            }

            @Override
            public Class<?> typeClass() {
                return EnumMap.class;
            }
        };
    }

    public EnumIO(Class<E> enumClass, IdStrategy strategy) {
        this.enumClass = enumClass;
        this.strategy = strategy;
        this.genericElementSchema = new ArraySchemas.EnumArray(strategy, null, this);
        Field[] fields = enumClass.getFields();
        int n = fields.length;
        this.alias = new String[n];
        this.tag = new int[n];
        this.valueByAliasMap = new HashMap<String, E>(n * 2);
        this.valueByTagMap = new HashMap<Integer, E>(n * 2);
        for (Enum instance : (Enum[])enumClass.getEnumConstants()) {
            int ordinal = instance.ordinal();
            try {
                Field field = enumClass.getField(instance.name());
                if (field.isAnnotationPresent(Tag.class)) {
                    Tag annotation = field.getAnnotation(Tag.class);
                    this.tag[ordinal] = annotation.value();
                    this.alias[ordinal] = annotation.alias();
                    this.valueByTagMap.put(annotation.value(), instance);
                    this.valueByAliasMap.put(annotation.alias(), instance);
                    continue;
                }
                this.tag[ordinal] = ordinal;
                this.alias[ordinal] = field.getName();
                this.valueByTagMap.put(ordinal, instance);
                this.valueByAliasMap.put(field.getName(), instance);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, PolymorphicSchema.Handler handler) {
        return new ArraySchemas.EnumArray(strategy, handler, this);
    }

    public int getTag(Enum<?> element) {
        return this.tag[element.ordinal()];
    }

    public String getAlias(Enum<?> element) {
        return this.alias[element.ordinal()];
    }

    public E getByTag(int tag) {
        return (E)((Enum)this.valueByTagMap.get(tag));
    }

    public E getByAlias(String alias) {
        return (E)((Enum)this.valueByAliasMap.get(alias));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSchema.MessageFactory getEnumSetFactory() {
        CollectionSchema.MessageFactory enumSetFactory = this.enumSetFactory;
        if (enumSetFactory == null) {
            EnumIO enumIO = this;
            synchronized (enumIO) {
                enumSetFactory = this.enumSetFactory;
                if (enumSetFactory == null) {
                    this.enumSetFactory = enumSetFactory = EnumIO.newEnumSetFactory(this);
                }
            }
        }
        return enumSetFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapSchema.MessageFactory getEnumMapFactory() {
        MapSchema.MessageFactory enumMapFactory = this.enumMapFactory;
        if (enumMapFactory == null) {
            EnumIO enumIO = this;
            synchronized (enumIO) {
                enumMapFactory = this.enumMapFactory;
                if (enumMapFactory == null) {
                    this.enumMapFactory = enumMapFactory = EnumIO.newEnumMapFactory(this);
                }
            }
        }
        return enumMapFactory;
    }

    public EnumSet<E> newEnumSet() {
        return EnumSet.noneOf(this.enumClass);
    }

    public <V> EnumMap<E, V> newEnumMap() {
        return new EnumMap(this.enumClass);
    }

    public abstract E readFrom(Input var1) throws IOException;

    static {
        boolean success = false;
        Field keyTypeFromMap = null;
        Field valueTypeFromSet = null;
        try {
            keyTypeFromMap = EnumMap.class.getDeclaredField("keyType");
            keyTypeFromMap.setAccessible(true);
            valueTypeFromSet = EnumSet.class.getDeclaredField("elementType");
            valueTypeFromSet.setAccessible(true);
            success = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        __keyTypeFromEnumMap = success ? keyTypeFromMap : null;
        __elementTypeFromEnumSet = success ? valueTypeFromSet : null;
    }

    public static final class ByNumber<E extends Enum<E>>
    extends EnumIO<E> {
        public ByNumber(Class<E> enumClass, IdStrategy strategy) {
            super(enumClass, strategy);
        }

        @Override
        public E readFrom(Input input) throws IOException {
            int tag = input.readEnum();
            return this.getByTag(tag);
        }
    }

    public static final class ByName<E extends Enum<E>>
    extends EnumIO<E> {
        public ByName(Class<E> enumClass, IdStrategy strategy) {
            super(enumClass, strategy);
        }

        @Override
        public E readFrom(Input input) throws IOException {
            String alias = input.readString();
            return this.getByAlias(alias);
        }
    }
}

