/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.aop.aspectj;

import com.baidu.cloud.thirdparty.springframework.aop.aspectj.AspectInstanceFactory;
import com.baidu.cloud.thirdparty.springframework.core.Ordered;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.io.Serializable;

public class SingletonAspectInstanceFactory
implements AspectInstanceFactory,
Serializable {
    private final Object aspectInstance;

    public SingletonAspectInstanceFactory(Object aspectInstance) {
        Assert.notNull(aspectInstance, "Aspect instance must not be null");
        this.aspectInstance = aspectInstance;
    }

    @Override
    public final Object getAspectInstance() {
        return this.aspectInstance;
    }

    @Override
    @Nullable
    public ClassLoader getAspectClassLoader() {
        return this.aspectInstance.getClass().getClassLoader();
    }

    @Override
    public int getOrder() {
        if (this.aspectInstance instanceof Ordered) {
            return ((Ordered)this.aspectInstance).getOrder();
        }
        return this.getOrderForAspectClass(this.aspectInstance.getClass());
    }

    protected int getOrderForAspectClass(Class<?> aspectClass) {
        return Integer.MAX_VALUE;
    }
}

