/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.aop.framework;

import com.baidu.cloud.thirdparty.springframework.aop.Advisor;
import com.baidu.cloud.thirdparty.springframework.aop.framework.Advised;
import com.baidu.cloud.thirdparty.springframework.aop.framework.AopInfrastructureBean;
import com.baidu.cloud.thirdparty.springframework.aop.framework.ProxyFactory;
import com.baidu.cloud.thirdparty.springframework.aop.framework.ProxyProcessorSupport;
import com.baidu.cloud.thirdparty.springframework.aop.support.AopUtils;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.BeanPostProcessor;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractAdvisingBeanPostProcessor
extends ProxyProcessorSupport
implements BeanPostProcessor {
    @Nullable
    protected Advisor advisor;
    protected boolean beforeExistingAdvisors = false;
    private final Map<Class<?>, Boolean> eligibleBeans = new ConcurrentHashMap(256);

    public void setBeforeExistingAdvisors(boolean beforeExistingAdvisors) {
        this.beforeExistingAdvisors = beforeExistingAdvisors;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) {
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) {
        Advised advised;
        if (this.advisor == null || bean2 instanceof AopInfrastructureBean) {
            return bean2;
        }
        if (bean2 instanceof Advised && !(advised = (Advised)bean2).isFrozen() && this.isEligible(AopUtils.getTargetClass(bean2))) {
            if (this.beforeExistingAdvisors) {
                advised.addAdvisor(0, this.advisor);
            } else {
                advised.addAdvisor(this.advisor);
            }
            return bean2;
        }
        if (this.isEligible(bean2, beanName)) {
            ProxyFactory proxyFactory = this.prepareProxyFactory(bean2, beanName);
            if (!proxyFactory.isProxyTargetClass()) {
                this.evaluateProxyInterfaces(bean2.getClass(), proxyFactory);
            }
            proxyFactory.addAdvisor(this.advisor);
            this.customizeProxyFactory(proxyFactory);
            return proxyFactory.getProxy(this.getProxyClassLoader());
        }
        return bean2;
    }

    protected boolean isEligible(Object bean2, String beanName) {
        return this.isEligible(bean2.getClass());
    }

    protected boolean isEligible(Class<?> targetClass) {
        Boolean eligible = this.eligibleBeans.get(targetClass);
        if (eligible != null) {
            return eligible;
        }
        if (this.advisor == null) {
            return false;
        }
        eligible = AopUtils.canApply(this.advisor, targetClass);
        this.eligibleBeans.put(targetClass, eligible);
        return eligible;
    }

    protected ProxyFactory prepareProxyFactory(Object bean2, String beanName) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.copyFrom(this);
        proxyFactory.setTarget(bean2);
        return proxyFactory;
    }

    protected void customizeProxyFactory(ProxyFactory proxyFactory) {
    }
}

