/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.aop.framework;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.springframework.aop.framework.AdvisedSupport;
import com.baidu.cloud.thirdparty.springframework.aop.framework.AopConfigException;
import com.baidu.cloud.thirdparty.springframework.aop.framework.CglibAopProxy;
import com.baidu.cloud.thirdparty.springframework.cglib.proxy.Callback;
import com.baidu.cloud.thirdparty.springframework.cglib.proxy.Enhancer;
import com.baidu.cloud.thirdparty.springframework.cglib.proxy.Factory;
import com.baidu.cloud.thirdparty.springframework.objenesis.SpringObjenesis;
import com.baidu.cloud.thirdparty.springframework.util.ReflectionUtils;
import java.lang.reflect.Constructor;

class ObjenesisCglibAopProxy
extends CglibAopProxy {
    private static final Log logger = LogFactory.getLog(ObjenesisCglibAopProxy.class);
    private static final SpringObjenesis objenesis = new SpringObjenesis();

    public ObjenesisCglibAopProxy(AdvisedSupport config) {
        super(config);
    }

    @Override
    protected Object createProxyClassAndInstance(Enhancer enhancer, Callback[] callbacks) {
        Class proxyClass = enhancer.createClass();
        Object proxyInstance = null;
        if (objenesis.isWorthTrying()) {
            try {
                proxyInstance = objenesis.newInstance(proxyClass, enhancer.getUseCache());
            }
            catch (Throwable ex) {
                logger.debug("Unable to instantiate proxy using Objenesis, falling back to regular proxy construction", ex);
            }
        }
        if (proxyInstance == null) {
            try {
                Constructor ctor = this.constructorArgs != null ? proxyClass.getDeclaredConstructor(this.constructorArgTypes) : proxyClass.getDeclaredConstructor(new Class[0]);
                ReflectionUtils.makeAccessible(ctor);
                proxyInstance = (this.constructorArgs != null ? ctor.newInstance(this.constructorArgs) : ctor.newInstance(new Object[0]));
            }
            catch (Throwable ex) {
                throw new AopConfigException("Unable to instantiate proxy using Objenesis, and regular proxy instantiation via default constructor fails as well", ex);
            }
        }
        ((Factory)proxyInstance).setCallbacks(callbacks);
        return proxyInstance;
    }
}

