/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.aop.target;

import com.baidu.cloud.thirdparty.pool2.ObjectPool;
import com.baidu.cloud.thirdparty.pool2.PooledObject;
import com.baidu.cloud.thirdparty.pool2.PooledObjectFactory;
import com.baidu.cloud.thirdparty.pool2.impl.DefaultPooledObject;
import com.baidu.cloud.thirdparty.pool2.impl.GenericObjectPool;
import com.baidu.cloud.thirdparty.pool2.impl.GenericObjectPoolConfig;
import com.baidu.cloud.thirdparty.springframework.aop.target.AbstractPoolingTargetSource;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;

public class CommonsPool2TargetSource
extends AbstractPoolingTargetSource
implements PooledObjectFactory<Object> {
    private int maxIdle = 8;
    private int minIdle = 0;
    private long maxWait = -1L;
    private long timeBetweenEvictionRunsMillis = -1L;
    private long minEvictableIdleTimeMillis = 1800000L;
    private boolean blockWhenExhausted = true;
    @Nullable
    private ObjectPool pool;

    public CommonsPool2TargetSource() {
        this.setMaxSize(8);
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setBlockWhenExhausted(boolean blockWhenExhausted) {
        this.blockWhenExhausted = blockWhenExhausted;
    }

    public boolean isBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    @Override
    protected final void createPool() {
        this.logger.debug("Creating Commons object pool");
        this.pool = this.createObjectPool();
    }

    protected ObjectPool createObjectPool() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(this.getMaxSize());
        config.setMaxIdle(this.getMaxIdle());
        config.setMinIdle(this.getMinIdle());
        config.setMaxWaitMillis(this.getMaxWait());
        config.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
        config.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis());
        config.setBlockWhenExhausted(this.isBlockWhenExhausted());
        return new GenericObjectPool<Object>(this, config);
    }

    @Override
    public Object getTarget() throws Exception {
        Assert.state(this.pool != null, "No Commons ObjectPool available");
        return this.pool.borrowObject();
    }

    @Override
    public void releaseTarget(Object target) throws Exception {
        if (this.pool != null) {
            this.pool.returnObject(target);
        }
    }

    @Override
    public int getActiveCount() throws UnsupportedOperationException {
        return this.pool != null ? this.pool.getNumActive() : 0;
    }

    @Override
    public int getIdleCount() throws UnsupportedOperationException {
        return this.pool != null ? this.pool.getNumIdle() : 0;
    }

    @Override
    public void destroy() throws Exception {
        if (this.pool != null) {
            this.logger.debug("Closing Commons ObjectPool");
            this.pool.close();
        }
    }

    @Override
    public PooledObject<Object> makeObject() throws Exception {
        return new DefaultPooledObject<Object>(this.newPrototypeInstance());
    }

    @Override
    public void destroyObject(PooledObject<Object> p) throws Exception {
        this.destroyPrototypeInstance(p.getObject());
    }

    @Override
    public boolean validateObject(PooledObject<Object> p) {
        return true;
    }

    @Override
    public void activateObject(PooledObject<Object> p) throws Exception {
    }

    @Override
    public void passivateObject(PooledObject<Object> p) throws Exception {
    }
}

