/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.beans.support;

import com.baidu.cloud.thirdparty.springframework.beans.PropertyEditorRegistrar;
import com.baidu.cloud.thirdparty.springframework.beans.PropertyEditorRegistry;
import com.baidu.cloud.thirdparty.springframework.beans.PropertyEditorRegistrySupport;
import com.baidu.cloud.thirdparty.springframework.beans.propertyeditors.ClassArrayEditor;
import com.baidu.cloud.thirdparty.springframework.beans.propertyeditors.ClassEditor;
import com.baidu.cloud.thirdparty.springframework.beans.propertyeditors.FileEditor;
import com.baidu.cloud.thirdparty.springframework.beans.propertyeditors.InputSourceEditor;
import com.baidu.cloud.thirdparty.springframework.beans.propertyeditors.InputStreamEditor;
import com.baidu.cloud.thirdparty.springframework.beans.propertyeditors.PathEditor;
import com.baidu.cloud.thirdparty.springframework.beans.propertyeditors.ReaderEditor;
import com.baidu.cloud.thirdparty.springframework.beans.propertyeditors.URIEditor;
import com.baidu.cloud.thirdparty.springframework.beans.propertyeditors.URLEditor;
import com.baidu.cloud.thirdparty.springframework.core.env.PropertyResolver;
import com.baidu.cloud.thirdparty.springframework.core.io.ContextResource;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.core.io.ResourceEditor;
import com.baidu.cloud.thirdparty.springframework.core.io.ResourceLoader;
import com.baidu.cloud.thirdparty.springframework.core.io.support.ResourceArrayPropertyEditor;
import com.baidu.cloud.thirdparty.springframework.core.io.support.ResourcePatternResolver;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import org.xml.sax.InputSource;

public class ResourceEditorRegistrar
implements PropertyEditorRegistrar {
    private final PropertyResolver propertyResolver;
    private final ResourceLoader resourceLoader;

    public ResourceEditorRegistrar(ResourceLoader resourceLoader, PropertyResolver propertyResolver) {
        this.resourceLoader = resourceLoader;
        this.propertyResolver = propertyResolver;
    }

    @Override
    public void registerCustomEditors(PropertyEditorRegistry registry) {
        ResourceEditor baseEditor = new ResourceEditor(this.resourceLoader, this.propertyResolver);
        this.doRegisterEditor(registry, Resource.class, baseEditor);
        this.doRegisterEditor(registry, ContextResource.class, baseEditor);
        this.doRegisterEditor(registry, InputStream.class, new InputStreamEditor(baseEditor));
        this.doRegisterEditor(registry, InputSource.class, new InputSourceEditor(baseEditor));
        this.doRegisterEditor(registry, File.class, new FileEditor(baseEditor));
        this.doRegisterEditor(registry, Path.class, new PathEditor(baseEditor));
        this.doRegisterEditor(registry, Reader.class, new ReaderEditor(baseEditor));
        this.doRegisterEditor(registry, URL.class, new URLEditor(baseEditor));
        ClassLoader classLoader = this.resourceLoader.getClassLoader();
        this.doRegisterEditor(registry, URI.class, new URIEditor(classLoader));
        this.doRegisterEditor(registry, Class.class, new ClassEditor(classLoader));
        this.doRegisterEditor(registry, Class[].class, new ClassArrayEditor(classLoader));
        if (this.resourceLoader instanceof ResourcePatternResolver) {
            this.doRegisterEditor(registry, Resource[].class, new ResourceArrayPropertyEditor((ResourcePatternResolver)this.resourceLoader, this.propertyResolver));
        }
    }

    private void doRegisterEditor(PropertyEditorRegistry registry, Class<?> requiredType, PropertyEditor editor) {
        if (registry instanceof PropertyEditorRegistrySupport) {
            ((PropertyEditorRegistrySupport)registry).overrideDefaultEditor(requiredType, editor);
        } else {
            registry.registerCustomEditor(requiredType, editor);
        }
    }
}

