/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.cache;

import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import java.util.concurrent.Callable;

public interface Cache {
    public String getName();

    public Object getNativeCache();

    @Nullable
    public ValueWrapper get(Object var1);

    @Nullable
    public <T> T get(Object var1, @Nullable Class<T> var2);

    @Nullable
    public <T> T get(Object var1, Callable<T> var2);

    public void put(Object var1, @Nullable Object var2);

    @Nullable
    public ValueWrapper putIfAbsent(Object var1, @Nullable Object var2);

    public void evict(Object var1);

    public void clear();

    public static class ValueRetrievalException
    extends RuntimeException {
        @Nullable
        private final Object key;

        public ValueRetrievalException(@Nullable Object key, Callable<?> loader, Throwable ex) {
            super(String.format("Value for key '%s' could not be loaded using '%s'", key, loader), ex);
            this.key = key;
        }

        @Nullable
        public Object getKey() {
            return this.key;
        }
    }

    @FunctionalInterface
    public static interface ValueWrapper {
        @Nullable
        public Object get();
    }
}

