/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.cache.annotation;

import com.baidu.cloud.thirdparty.springframework.beans.factory.annotation.Autowired;
import com.baidu.cloud.thirdparty.springframework.cache.CacheManager;
import com.baidu.cloud.thirdparty.springframework.cache.annotation.CachingConfigurer;
import com.baidu.cloud.thirdparty.springframework.cache.annotation.EnableCaching;
import com.baidu.cloud.thirdparty.springframework.cache.interceptor.CacheErrorHandler;
import com.baidu.cloud.thirdparty.springframework.cache.interceptor.CacheResolver;
import com.baidu.cloud.thirdparty.springframework.cache.interceptor.KeyGenerator;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Configuration;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ImportAware;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationAttributes;
import com.baidu.cloud.thirdparty.springframework.core.type.AnnotationMetadata;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import java.util.Collection;

@Configuration
public abstract class AbstractCachingConfiguration
implements ImportAware {
    @Nullable
    protected AnnotationAttributes enableCaching;
    @Nullable
    protected CacheManager cacheManager;
    @Nullable
    protected CacheResolver cacheResolver;
    @Nullable
    protected KeyGenerator keyGenerator;
    @Nullable
    protected CacheErrorHandler errorHandler;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableCaching = AnnotationAttributes.fromMap(importMetadata.getAnnotationAttributes(EnableCaching.class.getName(), false));
        if (this.enableCaching == null) {
            throw new IllegalArgumentException("@EnableCaching is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Autowired(required=false)
    void setConfigurers(Collection<CachingConfigurer> configurers) {
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException(configurers.size() + " implementations of CachingConfigurer were found when only 1 was expected. Refactor the configuration such that CachingConfigurer is implemented only once or not at all.");
        }
        CachingConfigurer configurer = configurers.iterator().next();
        this.useCachingConfigurer(configurer);
    }

    protected void useCachingConfigurer(CachingConfigurer config) {
        this.cacheManager = config.cacheManager();
        this.cacheResolver = config.cacheResolver();
        this.keyGenerator = config.keyGenerator();
        this.errorHandler = config.errorHandler();
    }
}

