/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.context.annotation;

import com.baidu.cloud.thirdparty.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.BeanDefinitionCustomizer;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.BeanDefinitionHolder;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.AutowireCandidateQualifier;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.BeanNameGenerator;
import com.baidu.cloud.thirdparty.springframework.context.annotation.AnnotationBeanNameGenerator;
import com.baidu.cloud.thirdparty.springframework.context.annotation.AnnotationConfigUtils;
import com.baidu.cloud.thirdparty.springframework.context.annotation.AnnotationScopeMetadataResolver;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ConditionEvaluator;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Lazy;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Primary;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ScopeMetadata;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ScopeMetadataResolver;
import com.baidu.cloud.thirdparty.springframework.core.env.Environment;
import com.baidu.cloud.thirdparty.springframework.core.env.EnvironmentCapable;
import com.baidu.cloud.thirdparty.springframework.core.env.StandardEnvironment;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;

public class AnnotatedBeanDefinitionReader {
    private final BeanDefinitionRegistry registry;
    private BeanNameGenerator beanNameGenerator = new AnnotationBeanNameGenerator();
    private ScopeMetadataResolver scopeMetadataResolver = new AnnotationScopeMetadataResolver();
    private ConditionEvaluator conditionEvaluator;

    public AnnotatedBeanDefinitionReader(BeanDefinitionRegistry registry) {
        this(registry, AnnotatedBeanDefinitionReader.getOrCreateEnvironment(registry));
    }

    public AnnotatedBeanDefinitionReader(BeanDefinitionRegistry registry, Environment environment2) {
        Assert.notNull((Object)registry, "BeanDefinitionRegistry must not be null");
        Assert.notNull((Object)environment2, "Environment must not be null");
        this.registry = registry;
        this.conditionEvaluator = new ConditionEvaluator(registry, environment2, null);
        AnnotationConfigUtils.registerAnnotationConfigProcessors(this.registry);
    }

    public final BeanDefinitionRegistry getRegistry() {
        return this.registry;
    }

    public void setEnvironment(Environment environment2) {
        this.conditionEvaluator = new ConditionEvaluator(this.registry, environment2, null);
    }

    public void setBeanNameGenerator(@Nullable BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator != null ? beanNameGenerator : new AnnotationBeanNameGenerator();
    }

    public void setScopeMetadataResolver(@Nullable ScopeMetadataResolver scopeMetadataResolver) {
        this.scopeMetadataResolver = scopeMetadataResolver != null ? scopeMetadataResolver : new AnnotationScopeMetadataResolver();
    }

    public void register(Class<?> ... annotatedClasses) {
        for (Class<?> annotatedClass : annotatedClasses) {
            this.registerBean(annotatedClass);
        }
    }

    public void registerBean(Class<?> annotatedClass) {
        this.doRegisterBean(annotatedClass, null, null, null, new BeanDefinitionCustomizer[0]);
    }

    public <T> void registerBean(Class<T> annotatedClass, @Nullable Supplier<T> instanceSupplier) {
        this.doRegisterBean(annotatedClass, instanceSupplier, null, null, new BeanDefinitionCustomizer[0]);
    }

    public <T> void registerBean(Class<T> annotatedClass, String name, @Nullable Supplier<T> instanceSupplier) {
        this.doRegisterBean(annotatedClass, instanceSupplier, name, null, new BeanDefinitionCustomizer[0]);
    }

    public void registerBean(Class<?> annotatedClass, Class<? extends Annotation> ... qualifiers) {
        this.doRegisterBean(annotatedClass, null, null, qualifiers, new BeanDefinitionCustomizer[0]);
    }

    public void registerBean(Class<?> annotatedClass, String name, Class<? extends Annotation> ... qualifiers) {
        this.doRegisterBean(annotatedClass, null, name, qualifiers, new BeanDefinitionCustomizer[0]);
    }

    <T> void doRegisterBean(Class<T> annotatedClass, @Nullable Supplier<T> instanceSupplier, @Nullable String name, @Nullable Class<? extends Annotation>[] qualifiers, BeanDefinitionCustomizer ... definitionCustomizers) {
        AnnotatedGenericBeanDefinition abd = new AnnotatedGenericBeanDefinition(annotatedClass);
        if (this.conditionEvaluator.shouldSkip(abd.getMetadata())) {
            return;
        }
        abd.setInstanceSupplier(instanceSupplier);
        ScopeMetadata scopeMetadata = this.scopeMetadataResolver.resolveScopeMetadata(abd);
        abd.setScope(scopeMetadata.getScopeName());
        String beanName = name != null ? name : this.beanNameGenerator.generateBeanName(abd, this.registry);
        AnnotationConfigUtils.processCommonDefinitionAnnotations(abd);
        if (qualifiers != null) {
            for (Class<? extends Annotation> qualifier : qualifiers) {
                if (Primary.class == qualifier) {
                    abd.setPrimary(true);
                    continue;
                }
                if (Lazy.class == qualifier) {
                    abd.setLazyInit(true);
                    continue;
                }
                abd.addQualifier(new AutowireCandidateQualifier(qualifier));
            }
        }
        for (BeanDefinitionCustomizer customizer2 : definitionCustomizers) {
            customizer2.customize(abd);
        }
        BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder(abd, beanName);
        definitionHolder = AnnotationConfigUtils.applyScopedProxyMode(scopeMetadata, definitionHolder, this.registry);
        BeanDefinitionReaderUtils.registerBeanDefinition(definitionHolder, this.registry);
    }

    private static Environment getOrCreateEnvironment(BeanDefinitionRegistry registry) {
        Assert.notNull((Object)registry, "BeanDefinitionRegistry must not be null");
        if (registry instanceof EnvironmentCapable) {
            return ((EnvironmentCapable)((Object)registry)).getEnvironment();
        }
        return new StandardEnvironment();
    }
}

