/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.context.annotation;

import com.baidu.cloud.thirdparty.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import com.baidu.cloud.thirdparty.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import com.baidu.cloud.thirdparty.springframework.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.BeanDefinitionHolder;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.AbstractBeanDefinition;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.DefaultListableBeanFactory;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.RootBeanDefinition;
import com.baidu.cloud.thirdparty.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ConfigurationClassPostProcessor;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import com.baidu.cloud.thirdparty.springframework.context.annotation.DependsOn;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Description;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Lazy;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Primary;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Role;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ScopeMetadata;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ScopedProxyCreator;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ScopedProxyMode;
import com.baidu.cloud.thirdparty.springframework.context.event.DefaultEventListenerFactory;
import com.baidu.cloud.thirdparty.springframework.context.event.EventListenerMethodProcessor;
import com.baidu.cloud.thirdparty.springframework.context.support.GenericApplicationContext;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationAttributes;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationAwareOrderComparator;
import com.baidu.cloud.thirdparty.springframework.core.type.AnnotatedTypeMetadata;
import com.baidu.cloud.thirdparty.springframework.core.type.AnnotationMetadata;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class AnnotationConfigUtils {
    public static final String CONFIGURATION_ANNOTATION_PROCESSOR_BEAN_NAME = "com.baidu.cloud.thirdparty.springframework.context.annotation.internalConfigurationAnnotationProcessor";
    public static final String CONFIGURATION_BEAN_NAME_GENERATOR = "com.baidu.cloud.thirdparty.springframework.context.annotation.internalConfigurationBeanNameGenerator";
    public static final String AUTOWIRED_ANNOTATION_PROCESSOR_BEAN_NAME = "com.baidu.cloud.thirdparty.springframework.context.annotation.internalAutowiredAnnotationProcessor";
    public static final String REQUIRED_ANNOTATION_PROCESSOR_BEAN_NAME = "com.baidu.cloud.thirdparty.springframework.context.annotation.internalRequiredAnnotationProcessor";
    public static final String COMMON_ANNOTATION_PROCESSOR_BEAN_NAME = "com.baidu.cloud.thirdparty.springframework.context.annotation.internalCommonAnnotationProcessor";
    public static final String PERSISTENCE_ANNOTATION_PROCESSOR_BEAN_NAME = "com.baidu.cloud.thirdparty.springframework.context.annotation.internalPersistenceAnnotationProcessor";
    private static final String PERSISTENCE_ANNOTATION_PROCESSOR_CLASS_NAME = "com.baidu.cloud.thirdparty.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor";
    public static final String EVENT_LISTENER_PROCESSOR_BEAN_NAME = "com.baidu.cloud.thirdparty.springframework.context.event.internalEventListenerProcessor";
    public static final String EVENT_LISTENER_FACTORY_BEAN_NAME = "com.baidu.cloud.thirdparty.springframework.context.event.internalEventListenerFactory";
    private static final boolean jsr250Present = ClassUtils.isPresent("javax.annotation.Resource", AnnotationConfigUtils.class.getClassLoader());
    private static final boolean jpaPresent = ClassUtils.isPresent("javax.persistence.EntityManagerFactory", AnnotationConfigUtils.class.getClassLoader()) && ClassUtils.isPresent("com.baidu.cloud.thirdparty.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor", AnnotationConfigUtils.class.getClassLoader());

    public static void registerAnnotationConfigProcessors(BeanDefinitionRegistry registry) {
        AnnotationConfigUtils.registerAnnotationConfigProcessors(registry, null);
    }

    public static Set<BeanDefinitionHolder> registerAnnotationConfigProcessors(BeanDefinitionRegistry registry, @Nullable Object source) {
        RootBeanDefinition def;
        DefaultListableBeanFactory beanFactory = AnnotationConfigUtils.unwrapDefaultListableBeanFactory(registry);
        if (beanFactory != null) {
            if (!(beanFactory.getDependencyComparator() instanceof AnnotationAwareOrderComparator)) {
                beanFactory.setDependencyComparator(AnnotationAwareOrderComparator.INSTANCE);
            }
            if (!(beanFactory.getAutowireCandidateResolver() instanceof ContextAnnotationAutowireCandidateResolver)) {
                beanFactory.setAutowireCandidateResolver(new ContextAnnotationAutowireCandidateResolver());
            }
        }
        LinkedHashSet<BeanDefinitionHolder> beanDefs = new LinkedHashSet<BeanDefinitionHolder>(8);
        if (!registry.containsBeanDefinition(CONFIGURATION_ANNOTATION_PROCESSOR_BEAN_NAME)) {
            def = new RootBeanDefinition(ConfigurationClassPostProcessor.class);
            def.setSource(source);
            beanDefs.add(AnnotationConfigUtils.registerPostProcessor(registry, def, CONFIGURATION_ANNOTATION_PROCESSOR_BEAN_NAME));
        }
        if (!registry.containsBeanDefinition(AUTOWIRED_ANNOTATION_PROCESSOR_BEAN_NAME)) {
            def = new RootBeanDefinition(AutowiredAnnotationBeanPostProcessor.class);
            def.setSource(source);
            beanDefs.add(AnnotationConfigUtils.registerPostProcessor(registry, def, AUTOWIRED_ANNOTATION_PROCESSOR_BEAN_NAME));
        }
        if (!registry.containsBeanDefinition(REQUIRED_ANNOTATION_PROCESSOR_BEAN_NAME)) {
            def = new RootBeanDefinition(RequiredAnnotationBeanPostProcessor.class);
            def.setSource(source);
            beanDefs.add(AnnotationConfigUtils.registerPostProcessor(registry, def, REQUIRED_ANNOTATION_PROCESSOR_BEAN_NAME));
        }
        if (jsr250Present && !registry.containsBeanDefinition(COMMON_ANNOTATION_PROCESSOR_BEAN_NAME)) {
            def = new RootBeanDefinition(CommonAnnotationBeanPostProcessor.class);
            def.setSource(source);
            beanDefs.add(AnnotationConfigUtils.registerPostProcessor(registry, def, COMMON_ANNOTATION_PROCESSOR_BEAN_NAME));
        }
        if (jpaPresent && !registry.containsBeanDefinition(PERSISTENCE_ANNOTATION_PROCESSOR_BEAN_NAME)) {
            def = new RootBeanDefinition();
            try {
                def.setBeanClass(ClassUtils.forName(PERSISTENCE_ANNOTATION_PROCESSOR_CLASS_NAME, AnnotationConfigUtils.class.getClassLoader()));
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Cannot load optional framework class: org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor", ex);
            }
            def.setSource(source);
            beanDefs.add(AnnotationConfigUtils.registerPostProcessor(registry, def, PERSISTENCE_ANNOTATION_PROCESSOR_BEAN_NAME));
        }
        if (!registry.containsBeanDefinition(EVENT_LISTENER_PROCESSOR_BEAN_NAME)) {
            def = new RootBeanDefinition(EventListenerMethodProcessor.class);
            def.setSource(source);
            beanDefs.add(AnnotationConfigUtils.registerPostProcessor(registry, def, EVENT_LISTENER_PROCESSOR_BEAN_NAME));
        }
        if (!registry.containsBeanDefinition(EVENT_LISTENER_FACTORY_BEAN_NAME)) {
            def = new RootBeanDefinition(DefaultEventListenerFactory.class);
            def.setSource(source);
            beanDefs.add(AnnotationConfigUtils.registerPostProcessor(registry, def, EVENT_LISTENER_FACTORY_BEAN_NAME));
        }
        return beanDefs;
    }

    private static BeanDefinitionHolder registerPostProcessor(BeanDefinitionRegistry registry, RootBeanDefinition definition, String beanName) {
        definition.setRole(2);
        registry.registerBeanDefinition(beanName, definition);
        return new BeanDefinitionHolder(definition, beanName);
    }

    @Nullable
    private static DefaultListableBeanFactory unwrapDefaultListableBeanFactory(BeanDefinitionRegistry registry) {
        if (registry instanceof DefaultListableBeanFactory) {
            return (DefaultListableBeanFactory)registry;
        }
        if (registry instanceof GenericApplicationContext) {
            return ((GenericApplicationContext)registry).getDefaultListableBeanFactory();
        }
        return null;
    }

    public static void processCommonDefinitionAnnotations(AnnotatedBeanDefinition abd) {
        AnnotationConfigUtils.processCommonDefinitionAnnotations(abd, abd.getMetadata());
    }

    static void processCommonDefinitionAnnotations(AnnotatedBeanDefinition abd, AnnotatedTypeMetadata metadata) {
        AnnotationAttributes dependsOn;
        AnnotationAttributes lazy = AnnotationConfigUtils.attributesFor(metadata, Lazy.class);
        if (lazy != null) {
            abd.setLazyInit(lazy.getBoolean("value"));
        } else if (abd.getMetadata() != metadata && (lazy = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)abd.getMetadata(), Lazy.class)) != null) {
            abd.setLazyInit(lazy.getBoolean("value"));
        }
        if (metadata.isAnnotated(Primary.class.getName())) {
            abd.setPrimary(true);
        }
        if ((dependsOn = AnnotationConfigUtils.attributesFor(metadata, DependsOn.class)) != null) {
            abd.setDependsOn(dependsOn.getStringArray("value"));
        }
        if (abd instanceof AbstractBeanDefinition) {
            AnnotationAttributes description;
            AbstractBeanDefinition absBd = (AbstractBeanDefinition)((Object)abd);
            AnnotationAttributes role = AnnotationConfigUtils.attributesFor(metadata, Role.class);
            if (role != null) {
                absBd.setRole(((Number)role.getNumber("value")).intValue());
            }
            if ((description = AnnotationConfigUtils.attributesFor(metadata, Description.class)) != null) {
                absBd.setDescription(description.getString("value"));
            }
        }
    }

    static BeanDefinitionHolder applyScopedProxyMode(ScopeMetadata metadata, BeanDefinitionHolder definition, BeanDefinitionRegistry registry) {
        ScopedProxyMode scopedProxyMode = metadata.getScopedProxyMode();
        if (scopedProxyMode.equals((Object)ScopedProxyMode.NO)) {
            return definition;
        }
        boolean proxyTargetClass = scopedProxyMode.equals((Object)ScopedProxyMode.TARGET_CLASS);
        return ScopedProxyCreator.createScopedProxy(definition, registry, proxyTargetClass);
    }

    @Nullable
    static AnnotationAttributes attributesFor(AnnotatedTypeMetadata metadata, Class<?> annotationClass) {
        return AnnotationConfigUtils.attributesFor(metadata, annotationClass.getName());
    }

    @Nullable
    static AnnotationAttributes attributesFor(AnnotatedTypeMetadata metadata, String annotationClassName) {
        return AnnotationAttributes.fromMap(metadata.getAnnotationAttributes(annotationClassName, false));
    }

    static Set<AnnotationAttributes> attributesForRepeatable(AnnotationMetadata metadata, Class<?> containerClass, Class<?> annotationClass) {
        return AnnotationConfigUtils.attributesForRepeatable(metadata, containerClass.getName(), annotationClass.getName());
    }

    static Set<AnnotationAttributes> attributesForRepeatable(AnnotationMetadata metadata, String containerClassName, String annotationClassName) {
        LinkedHashSet<AnnotationAttributes> result = new LinkedHashSet<AnnotationAttributes>();
        AnnotationConfigUtils.addAttributesIfNotNull(result, metadata.getAnnotationAttributes(annotationClassName, false));
        Map<String, Object> container = metadata.getAnnotationAttributes(containerClassName, false);
        if (container != null && container.containsKey("value")) {
            for (Map containedAttributes : (Map[])container.get("value")) {
                AnnotationConfigUtils.addAttributesIfNotNull(result, containedAttributes);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static void addAttributesIfNotNull(Set<AnnotationAttributes> result, @Nullable Map<String, Object> attributes) {
        if (attributes != null) {
            result.add(AnnotationAttributes.fromMap(attributes));
        }
    }
}

