/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.context.annotation;

import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanClassLoaderAware;
import com.baidu.cloud.thirdparty.springframework.beans.factory.annotation.Autowired;
import com.baidu.cloud.thirdparty.springframework.context.annotation.AnnotationConfigUtils;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Bean;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Configuration;
import com.baidu.cloud.thirdparty.springframework.context.annotation.EnableLoadTimeWeaving;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ImportAware;
import com.baidu.cloud.thirdparty.springframework.context.annotation.LoadTimeWeavingConfigurer;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Role;
import com.baidu.cloud.thirdparty.springframework.context.weaving.AspectJWeavingEnabler;
import com.baidu.cloud.thirdparty.springframework.context.weaving.DefaultContextLoadTimeWeaver;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationAttributes;
import com.baidu.cloud.thirdparty.springframework.core.type.AnnotatedTypeMetadata;
import com.baidu.cloud.thirdparty.springframework.core.type.AnnotationMetadata;
import com.baidu.cloud.thirdparty.springframework.instrument.classloading.LoadTimeWeaver;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;

@Configuration
public class LoadTimeWeavingConfiguration
implements ImportAware,
BeanClassLoaderAware {
    @Nullable
    private AnnotationAttributes enableLTW;
    @Nullable
    private LoadTimeWeavingConfigurer ltwConfigurer;
    @Nullable
    private ClassLoader beanClassLoader;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableLTW = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)importMetadata, EnableLoadTimeWeaving.class);
        if (this.enableLTW == null) {
            throw new IllegalArgumentException("@EnableLoadTimeWeaving is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Autowired(required=false)
    public void setLoadTimeWeavingConfigurer(LoadTimeWeavingConfigurer ltwConfigurer) {
        this.ltwConfigurer = ltwConfigurer;
    }

    @Override
    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Bean(name={"loadTimeWeaver"})
    @Role(value=2)
    public LoadTimeWeaver loadTimeWeaver() {
        Assert.state(this.beanClassLoader != null, "No ClassLoader set");
        LoadTimeWeaver loadTimeWeaver = null;
        if (this.ltwConfigurer != null) {
            loadTimeWeaver = this.ltwConfigurer.getLoadTimeWeaver();
        }
        if (loadTimeWeaver == null) {
            loadTimeWeaver = new DefaultContextLoadTimeWeaver(this.beanClassLoader);
        }
        if (this.enableLTW != null) {
            EnableLoadTimeWeaving.AspectJWeaving aspectJWeaving = (EnableLoadTimeWeaving.AspectJWeaving)((Object)this.enableLTW.getEnum("aspectjWeaving"));
            switch (aspectJWeaving) {
                case DISABLED: {
                    break;
                }
                case AUTODETECT: {
                    if (this.beanClassLoader.getResource("META-INF/aop.xml") == null) break;
                    AspectJWeavingEnabler.enableAspectJWeaving(loadTimeWeaver, this.beanClassLoader);
                    break;
                }
                case ENABLED: {
                    AspectJWeavingEnabler.enableAspectJWeaving(loadTimeWeaver, this.beanClassLoader);
                }
            }
        }
        return loadTimeWeaver;
    }
}

