/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.core.type.classreading;

import com.baidu.cloud.thirdparty.springframework.asm.ClassReader;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.core.type.AnnotationMetadata;
import com.baidu.cloud.thirdparty.springframework.core.type.ClassMetadata;
import com.baidu.cloud.thirdparty.springframework.core.type.classreading.AnnotationMetadataReadingVisitor;
import com.baidu.cloud.thirdparty.springframework.core.type.classreading.MetadataReader;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import java.io.BufferedInputStream;
import java.io.IOException;

final class SimpleMetadataReader
implements MetadataReader {
    private final Resource resource;
    private final ClassMetadata classMetadata;
    private final AnnotationMetadata annotationMetadata;

    SimpleMetadataReader(Resource resource, @Nullable ClassLoader classLoader) throws IOException {
        ClassReader classReader;
        try (BufferedInputStream is = new BufferedInputStream(resource.getInputStream());){
            classReader = new ClassReader(is);
        }
        AnnotationMetadataReadingVisitor visitor = new AnnotationMetadataReadingVisitor(classLoader);
        classReader.accept(visitor, 2);
        this.annotationMetadata = visitor;
        this.classMetadata = visitor;
        this.resource = resource;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public ClassMetadata getClassMetadata() {
        return this.classMetadata;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }
}

