/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.format.datetime.joda;

import com.baidu.cloud.thirdparty.springframework.context.support.EmbeddedValueResolutionSupport;
import com.baidu.cloud.thirdparty.springframework.format.AnnotationFormatterFactory;
import com.baidu.cloud.thirdparty.springframework.format.Parser;
import com.baidu.cloud.thirdparty.springframework.format.Printer;
import com.baidu.cloud.thirdparty.springframework.format.annotation.DateTimeFormat;
import com.baidu.cloud.thirdparty.springframework.format.datetime.joda.DateTimeFormatterFactory;
import com.baidu.cloud.thirdparty.springframework.format.datetime.joda.DateTimeParser;
import com.baidu.cloud.thirdparty.springframework.format.datetime.joda.LocalDateParser;
import com.baidu.cloud.thirdparty.springframework.format.datetime.joda.LocalDateTimeParser;
import com.baidu.cloud.thirdparty.springframework.format.datetime.joda.LocalTimeParser;
import com.baidu.cloud.thirdparty.springframework.format.datetime.joda.MillisecondInstantPrinter;
import com.baidu.cloud.thirdparty.springframework.format.datetime.joda.ReadableInstantPrinter;
import com.baidu.cloud.thirdparty.springframework.format.datetime.joda.ReadablePartialPrinter;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;

public class JodaDateTimeFormatAnnotationFormatterFactory
extends EmbeddedValueResolutionSupport
implements AnnotationFormatterFactory<DateTimeFormat> {
    private static final Set<Class<?>> FIELD_TYPES;

    @Override
    public final Set<Class<?>> getFieldTypes() {
        return FIELD_TYPES;
    }

    @Override
    public Printer<?> getPrinter(DateTimeFormat annotation, Class<?> fieldType) {
        DateTimeFormatter formatter = this.getFormatter(annotation, fieldType);
        if (ReadablePartial.class.isAssignableFrom(fieldType)) {
            return new ReadablePartialPrinter(formatter);
        }
        if (ReadableInstant.class.isAssignableFrom(fieldType) || Calendar.class.isAssignableFrom(fieldType)) {
            return new ReadableInstantPrinter(formatter);
        }
        return new MillisecondInstantPrinter(formatter);
    }

    @Override
    public Parser<?> getParser(DateTimeFormat annotation, Class<?> fieldType) {
        if (LocalDate.class == fieldType) {
            return new LocalDateParser(this.getFormatter(annotation, fieldType));
        }
        if (LocalTime.class == fieldType) {
            return new LocalTimeParser(this.getFormatter(annotation, fieldType));
        }
        if (LocalDateTime.class == fieldType) {
            return new LocalDateTimeParser(this.getFormatter(annotation, fieldType));
        }
        return new DateTimeParser(this.getFormatter(annotation, fieldType));
    }

    protected DateTimeFormatter getFormatter(DateTimeFormat annotation, Class<?> fieldType) {
        DateTimeFormatterFactory factory = new DateTimeFormatterFactory();
        String style = this.resolveEmbeddedValue(annotation.style());
        if (StringUtils.hasLength(style)) {
            factory.setStyle(style);
        }
        factory.setIso(annotation.iso());
        String pattern = this.resolveEmbeddedValue(annotation.pattern());
        if (StringUtils.hasLength(pattern)) {
            factory.setPattern(pattern);
        }
        return factory.createDateTimeFormatter();
    }

    static {
        HashSet<Class<Long>> fieldTypes = new HashSet<Class<Long>>(8);
        fieldTypes.add(ReadableInstant.class);
        fieldTypes.add(LocalDate.class);
        fieldTypes.add(LocalTime.class);
        fieldTypes.add(LocalDateTime.class);
        fieldTypes.add(Date.class);
        fieldTypes.add(Calendar.class);
        fieldTypes.add(Long.class);
        FIELD_TYPES = Collections.unmodifiableSet(fieldTypes);
    }
}

