/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.format.number;

import com.baidu.cloud.thirdparty.springframework.context.support.EmbeddedValueResolutionSupport;
import com.baidu.cloud.thirdparty.springframework.format.AnnotationFormatterFactory;
import com.baidu.cloud.thirdparty.springframework.format.Formatter;
import com.baidu.cloud.thirdparty.springframework.format.Parser;
import com.baidu.cloud.thirdparty.springframework.format.Printer;
import com.baidu.cloud.thirdparty.springframework.format.annotation.NumberFormat;
import com.baidu.cloud.thirdparty.springframework.format.number.CurrencyStyleFormatter;
import com.baidu.cloud.thirdparty.springframework.format.number.NumberStyleFormatter;
import com.baidu.cloud.thirdparty.springframework.format.number.PercentStyleFormatter;
import com.baidu.cloud.thirdparty.springframework.util.NumberUtils;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import java.util.Set;

public class NumberFormatAnnotationFormatterFactory
extends EmbeddedValueResolutionSupport
implements AnnotationFormatterFactory<NumberFormat> {
    @Override
    public Set<Class<?>> getFieldTypes() {
        return NumberUtils.STANDARD_NUMBER_TYPES;
    }

    @Override
    public Printer<Number> getPrinter(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation);
    }

    @Override
    public Parser<Number> getParser(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation);
    }

    private Formatter<Number> configureFormatterFrom(NumberFormat annotation) {
        String pattern = this.resolveEmbeddedValue(annotation.pattern());
        if (StringUtils.hasLength(pattern)) {
            return new NumberStyleFormatter(pattern);
        }
        NumberFormat.Style style = annotation.style();
        if (style == NumberFormat.Style.CURRENCY) {
            return new CurrencyStyleFormatter();
        }
        if (style == NumberFormat.Style.PERCENT) {
            return new PercentStyleFormatter();
        }
        return new NumberStyleFormatter();
    }
}

