/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.client;

import com.baidu.cloud.thirdparty.springframework.http.HttpHeaders;
import com.baidu.cloud.thirdparty.springframework.http.HttpMethod;
import com.baidu.cloud.thirdparty.springframework.http.client.AbstractBufferingClientHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.client.BufferingClientHttpResponseWrapper;
import com.baidu.cloud.thirdparty.springframework.http.client.ClientHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.client.ClientHttpResponse;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.StreamUtils;
import java.io.IOException;
import java.net.URI;

final class BufferingClientHttpRequestWrapper
extends AbstractBufferingClientHttpRequest {
    private final ClientHttpRequest request;

    BufferingClientHttpRequestWrapper(ClientHttpRequest request) {
        this.request = request;
    }

    @Override
    @Nullable
    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getMethodValue() {
        return this.request.getMethodValue();
    }

    @Override
    public URI getURI() {
        return this.request.getURI();
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, byte[] bufferedOutput) throws IOException {
        this.request.getHeaders().putAll(headers);
        StreamUtils.copy(bufferedOutput, this.request.getBody());
        ClientHttpResponse response = this.request.execute();
        return new BufferingClientHttpResponseWrapper(response);
    }
}

