/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.client;

import com.baidu.cloud.thirdparty.netty.bootstrap.Bootstrap;
import com.baidu.cloud.thirdparty.netty.channel.ChannelInitializer;
import com.baidu.cloud.thirdparty.netty.channel.ChannelPipeline;
import com.baidu.cloud.thirdparty.netty.channel.EventLoopGroup;
import com.baidu.cloud.thirdparty.netty.channel.nio.NioEventLoopGroup;
import com.baidu.cloud.thirdparty.netty.channel.socket.SocketChannel;
import com.baidu.cloud.thirdparty.netty.channel.socket.SocketChannelConfig;
import com.baidu.cloud.thirdparty.netty.channel.socket.nio.NioSocketChannel;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpClientCodec;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpObjectAggregator;
import com.baidu.cloud.thirdparty.netty.handler.ssl.SslContext;
import com.baidu.cloud.thirdparty.netty.handler.ssl.SslContextBuilder;
import com.baidu.cloud.thirdparty.netty.handler.timeout.ReadTimeoutHandler;
import com.baidu.cloud.thirdparty.springframework.beans.factory.DisposableBean;
import com.baidu.cloud.thirdparty.springframework.beans.factory.InitializingBean;
import com.baidu.cloud.thirdparty.springframework.http.HttpMethod;
import com.baidu.cloud.thirdparty.springframework.http.client.AsyncClientHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.client.AsyncClientHttpRequestFactory;
import com.baidu.cloud.thirdparty.springframework.http.client.ClientHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.client.ClientHttpRequestFactory;
import com.baidu.cloud.thirdparty.springframework.http.client.Netty4ClientHttpRequest;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;

@Deprecated
public class Netty4ClientHttpRequestFactory
implements ClientHttpRequestFactory,
AsyncClientHttpRequestFactory,
InitializingBean,
DisposableBean {
    public static final int DEFAULT_MAX_RESPONSE_SIZE = 0xA00000;
    private final EventLoopGroup eventLoopGroup;
    private final boolean defaultEventLoopGroup;
    private int maxResponseSize = 0xA00000;
    @Nullable
    private SslContext sslContext;
    private int connectTimeout = -1;
    private int readTimeout = -1;
    @Nullable
    private volatile Bootstrap bootstrap;

    public Netty4ClientHttpRequestFactory() {
        int ioWorkerCount = Runtime.getRuntime().availableProcessors() * 2;
        this.eventLoopGroup = new NioEventLoopGroup(ioWorkerCount);
        this.defaultEventLoopGroup = true;
    }

    public Netty4ClientHttpRequestFactory(EventLoopGroup eventLoopGroup) {
        Assert.notNull((Object)eventLoopGroup, "EventLoopGroup must not be null");
        this.eventLoopGroup = eventLoopGroup;
        this.defaultEventLoopGroup = false;
    }

    public void setMaxResponseSize(int maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
    }

    public void setSslContext(SslContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.sslContext == null) {
            this.sslContext = this.getDefaultClientSslContext();
        }
    }

    private SslContext getDefaultClientSslContext() {
        try {
            return SslContextBuilder.forClient().build();
        }
        catch (SSLException ex) {
            throw new IllegalStateException("Could not create default client SslContext", ex);
        }
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return this.createRequestInternal(uri, httpMethod);
    }

    @Override
    public AsyncClientHttpRequest createAsyncRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return this.createRequestInternal(uri, httpMethod);
    }

    private Netty4ClientHttpRequest createRequestInternal(URI uri, HttpMethod httpMethod) {
        return new Netty4ClientHttpRequest(this.getBootstrap(uri), uri, httpMethod);
    }

    private Bootstrap getBootstrap(URI uri) {
        boolean isSecure;
        boolean bl = isSecure = uri.getPort() == 443 || "https".equalsIgnoreCase(uri.getScheme());
        if (isSecure) {
            return this.buildBootstrap(uri, true);
        }
        Bootstrap bootstrap = this.bootstrap;
        if (bootstrap == null) {
            this.bootstrap = bootstrap = this.buildBootstrap(uri, false);
        }
        return bootstrap;
    }

    private Bootstrap buildBootstrap(final URI uri, final boolean isSecure) {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)bootstrap.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel channel) throws Exception {
                Netty4ClientHttpRequestFactory.this.configureChannel(channel.config());
                ChannelPipeline pipeline = channel.pipeline();
                if (isSecure) {
                    Assert.notNull((Object)Netty4ClientHttpRequestFactory.this.sslContext, "sslContext should not be null");
                    pipeline.addLast(Netty4ClientHttpRequestFactory.this.sslContext.newHandler(channel.alloc(), uri.getHost(), uri.getPort()));
                }
                pipeline.addLast(new HttpClientCodec());
                pipeline.addLast(new HttpObjectAggregator(Netty4ClientHttpRequestFactory.this.maxResponseSize));
                if (Netty4ClientHttpRequestFactory.this.readTimeout > 0) {
                    pipeline.addLast(new ReadTimeoutHandler(Netty4ClientHttpRequestFactory.this.readTimeout, TimeUnit.MILLISECONDS));
                }
            }
        });
        return bootstrap;
    }

    protected void configureChannel(SocketChannelConfig config) {
        if (this.connectTimeout >= 0) {
            config.setConnectTimeoutMillis(this.connectTimeout);
        }
    }

    @Override
    public void destroy() throws InterruptedException {
        if (this.defaultEventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully().sync();
        }
    }
}

