/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.client.support;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.springframework.http.HttpMethod;
import com.baidu.cloud.thirdparty.springframework.http.client.ClientHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.client.ClientHttpRequestFactory;
import com.baidu.cloud.thirdparty.springframework.http.client.SimpleClientHttpRequestFactory;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.io.IOException;
import java.net.URI;

public abstract class HttpAccessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        Assert.notNull((Object)requestFactory, "ClientHttpRequestFactory must not be null");
        this.requestFactory = requestFactory;
    }

    public ClientHttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    protected ClientHttpRequest createRequest(URI url, HttpMethod method) throws IOException {
        ClientHttpRequest request = this.getRequestFactory().createRequest(url, method);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Created " + method.name() + " request for \"" + url + "\"");
        }
        return request;
    }
}

