/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.codec.json;

import com.baidu.cloud.thirdparty.jackson.core.PrettyPrinter;
import com.baidu.cloud.thirdparty.jackson.core.util.DefaultIndenter;
import com.baidu.cloud.thirdparty.jackson.core.util.DefaultPrettyPrinter;
import com.baidu.cloud.thirdparty.jackson.databind.ObjectMapper;
import com.baidu.cloud.thirdparty.jackson.databind.ObjectWriter;
import com.baidu.cloud.thirdparty.jackson.databind.SerializationFeature;
import com.baidu.cloud.thirdparty.springframework.core.ResolvableType;
import com.baidu.cloud.thirdparty.springframework.http.MediaType;
import com.baidu.cloud.thirdparty.springframework.http.codec.json.AbstractJackson2Encoder;
import com.baidu.cloud.thirdparty.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.MimeType;
import java.util.Collections;
import java.util.Map;

public class Jackson2JsonEncoder
extends AbstractJackson2Encoder {
    @Nullable
    private final PrettyPrinter ssePrettyPrinter;

    public Jackson2JsonEncoder() {
        this((ObjectMapper)Jackson2ObjectMapperBuilder.json().build(), new MimeType[0]);
    }

    public Jackson2JsonEncoder(ObjectMapper mapper, MimeType ... mimeTypes) {
        super(mapper, mimeTypes);
        this.setStreamingMediaTypes(Collections.singletonList(MediaType.APPLICATION_STREAM_JSON));
        this.ssePrettyPrinter = Jackson2JsonEncoder.initSsePrettyPrinter();
    }

    private static PrettyPrinter initSsePrettyPrinter() {
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        printer.indentObjectsWith(new DefaultIndenter("  ", "\ndata:"));
        return printer;
    }

    @Override
    protected ObjectWriter customizeWriter(ObjectWriter writer, @Nullable MimeType mimeType, ResolvableType elementType, @Nullable Map<String, Object> hints) {
        return this.ssePrettyPrinter != null && MediaType.TEXT_EVENT_STREAM.isCompatibleWith(mimeType) && writer.getConfig().isEnabled(SerializationFeature.INDENT_OUTPUT) ? writer.with(this.ssePrettyPrinter) : writer;
    }
}

