/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.codec.json;

import com.baidu.cloud.thirdparty.jackson.databind.ObjectMapper;
import com.baidu.cloud.thirdparty.jackson.dataformat.smile.SmileFactory;
import com.baidu.cloud.thirdparty.springframework.http.MediaType;
import com.baidu.cloud.thirdparty.springframework.http.codec.json.AbstractJackson2Encoder;
import com.baidu.cloud.thirdparty.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.MimeType;
import java.nio.charset.StandardCharsets;
import java.util.Collections;

public class Jackson2SmileEncoder
extends AbstractJackson2Encoder {
    private static final MimeType[] DEFAULT_SMILE_MIME_TYPES = new MimeType[]{new MimeType("application", "x-jackson-smile", StandardCharsets.UTF_8), new MimeType("application", "*+x-jackson-smile", StandardCharsets.UTF_8)};

    public Jackson2SmileEncoder() {
        this((ObjectMapper)Jackson2ObjectMapperBuilder.smile().build(), DEFAULT_SMILE_MIME_TYPES);
    }

    public Jackson2SmileEncoder(ObjectMapper mapper, MimeType ... mimeTypes) {
        super(mapper, mimeTypes);
        Assert.isAssignable(SmileFactory.class, mapper.getFactory().getClass());
        this.setStreamingMediaTypes(Collections.singletonList(new MediaType("application", "stream+x-jackson-smile")));
    }
}

