/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.converter.json;

import com.baidu.cloud.thirdparty.springframework.http.converter.json.AbstractJsonHttpMessageConverter;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.google.gson.Gson;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class GsonHttpMessageConverter
extends AbstractJsonHttpMessageConverter {
    private Gson gson;

    public GsonHttpMessageConverter() {
        this.gson = new Gson();
    }

    public GsonHttpMessageConverter(Gson gson) {
        Assert.notNull((Object)gson, "A Gson instance is required");
        this.gson = gson;
    }

    public void setGson(Gson gson) {
        Assert.notNull((Object)gson, "A Gson instance is required");
        this.gson = gson;
    }

    public Gson getGson() {
        return this.gson;
    }

    @Override
    protected Object readInternal(Type resolvedType, Reader reader) throws Exception {
        return this.getGson().fromJson(reader, resolvedType);
    }

    @Override
    protected void writeInternal(Object o, @Nullable Type type, Writer writer) throws Exception {
        if (type instanceof ParameterizedType) {
            this.getGson().toJson(o, type, (Appendable)writer);
        } else {
            this.getGson().toJson(o, (Appendable)writer);
        }
    }
}

