/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.server.reactive;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.reactivestreams.Publisher;
import com.baidu.cloud.thirdparty.servlet.AsyncContext;
import com.baidu.cloud.thirdparty.servlet.AsyncEvent;
import com.baidu.cloud.thirdparty.servlet.AsyncListener;
import com.baidu.cloud.thirdparty.servlet.ReadListener;
import com.baidu.cloud.thirdparty.servlet.ServletInputStream;
import com.baidu.cloud.thirdparty.servlet.http.Cookie;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DataBuffer;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DataBufferFactory;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DefaultDataBufferFactory;
import com.baidu.cloud.thirdparty.springframework.http.HttpCookie;
import com.baidu.cloud.thirdparty.springframework.http.HttpHeaders;
import com.baidu.cloud.thirdparty.springframework.http.MediaType;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.AbstractListenerReadPublisher;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.AbstractServerHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.DefaultSslInfo;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.SslInfo;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.LinkedCaseInsensitiveMap;
import com.baidu.cloud.thirdparty.springframework.util.LinkedMultiValueMap;
import com.baidu.cloud.thirdparty.springframework.util.MultiValueMap;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import reactor.core.publisher.Flux;

class ServletServerHttpRequest
extends AbstractServerHttpRequest {
    static final DataBuffer EOF_BUFFER = new DefaultDataBufferFactory().allocateBuffer(0);
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final HttpServletRequest request;
    private final RequestBodyPublisher bodyPublisher;
    private final Object cookieLock = new Object();
    private final DataBufferFactory bufferFactory;
    private final byte[] buffer;

    public ServletServerHttpRequest(HttpServletRequest request, AsyncContext asyncContext, String servletPath, DataBufferFactory bufferFactory, int bufferSize) throws IOException, URISyntaxException {
        super(ServletServerHttpRequest.initUri(request), request.getContextPath() + servletPath, ServletServerHttpRequest.initHeaders(request));
        Assert.notNull((Object)bufferFactory, "'bufferFactory' must not be null");
        Assert.isTrue(bufferSize > 0, "'bufferSize' must be higher than 0");
        this.request = request;
        this.bufferFactory = bufferFactory;
        this.buffer = new byte[bufferSize];
        asyncContext.addListener(new RequestAsyncListener());
        ServletInputStream inputStream = request.getInputStream();
        this.bodyPublisher = new RequestBodyPublisher(inputStream);
        this.bodyPublisher.registerReadListener();
    }

    private static URI initUri(HttpServletRequest request) throws URISyntaxException {
        Assert.notNull((Object)request, "'request' must not be null");
        StringBuffer url = request.getRequestURL();
        String query = request.getQueryString();
        if (StringUtils.hasText(query)) {
            url.append('?').append(query);
        }
        return new URI(url.toString());
    }

    private static HttpHeaders initHeaders(HttpServletRequest request) {
        int contentLength;
        String encoding;
        String requestContentType;
        HttpHeaders headers = new HttpHeaders();
        Enumeration<String> names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Enumeration<String> values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                headers.add(name, values.nextElement());
            }
        }
        MediaType contentType = headers.getContentType();
        if (contentType == null && StringUtils.hasLength(requestContentType = request.getContentType())) {
            contentType = MediaType.parseMediaType(requestContentType);
            headers.setContentType(contentType);
        }
        if (contentType != null && contentType.getCharset() == null && StringUtils.hasLength(encoding = request.getCharacterEncoding())) {
            Charset charset = Charset.forName(encoding);
            LinkedCaseInsensitiveMap<String> params = new LinkedCaseInsensitiveMap<String>();
            params.putAll(contentType.getParameters());
            params.put("charset", charset.toString());
            headers.setContentType(new MediaType(contentType.getType(), contentType.getSubtype(), params));
        }
        if (headers.getContentLength() == -1L && (contentLength = request.getContentLength()) != -1) {
            headers.setContentLength(contentLength);
        }
        return headers;
    }

    @Override
    public String getMethodValue() {
        return this.request.getMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap<String, HttpCookie> httpCookies = new LinkedMultiValueMap<String, HttpCookie>();
        Cookie[] cookieArray = this.cookieLock;
        synchronized (this.cookieLock) {
            Cookie[] cookies = this.request.getCookies();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    String name = cookie.getName();
                    HttpCookie httpCookie = new HttpCookie(name, cookie.getValue());
                    httpCookies.add(name, httpCookie);
                }
            }
            return httpCookies;
        }
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.request.getRemoteHost(), this.request.getRemotePort());
    }

    @Override
    @Nullable
    protected SslInfo initSslInfo() {
        X509Certificate[] certificates = this.getX509Certificates();
        return certificates != null ? new DefaultSslInfo(this.getSslSessionId(), certificates) : null;
    }

    @Nullable
    private String getSslSessionId() {
        return (String)this.request.getAttribute("com.baidu.cloud.thirdparty.servlet.request.ssl_session_id");
    }

    @Nullable
    private X509Certificate[] getX509Certificates() {
        String name = "com.baidu.cloud.thirdparty.servlet.request.X509Certificate";
        return (X509Certificate[])this.request.getAttribute(name);
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return Flux.from((Publisher)this.bodyPublisher);
    }

    @Nullable
    DataBuffer readFromInputStream() throws IOException {
        int read = this.request.getInputStream().read(this.buffer);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("InputStream read returned " + read + (read != -1 ? " bytes" : ""));
        }
        if (read > 0) {
            DataBuffer dataBuffer = this.bufferFactory.allocateBuffer(read);
            dataBuffer.write(this.buffer, 0, read);
            return dataBuffer;
        }
        if (read == -1) {
            return EOF_BUFFER;
        }
        return null;
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.request;
    }

    private class RequestBodyPublisher
    extends AbstractListenerReadPublisher<DataBuffer> {
        private final ServletInputStream inputStream;

        public RequestBodyPublisher(ServletInputStream inputStream) {
            this.inputStream = inputStream;
        }

        public void registerReadListener() throws IOException {
            this.inputStream.setReadListener(new RequestBodyPublisherReadListener());
        }

        @Override
        protected void checkOnDataAvailable() {
            if (this.inputStream.isReady() && !this.inputStream.isFinished()) {
                this.onDataAvailable();
            }
        }

        @Override
        @Nullable
        protected DataBuffer read() throws IOException {
            if (this.inputStream.isReady()) {
                DataBuffer dataBuffer = ServletServerHttpRequest.this.readFromInputStream();
                if (dataBuffer == EOF_BUFFER) {
                    this.onAllDataRead();
                    dataBuffer = null;
                }
                return dataBuffer;
            }
            return null;
        }

        @Override
        protected void readingPaused() {
        }

        @Override
        protected void discardData() {
        }

        private class RequestBodyPublisherReadListener
        implements ReadListener {
            private RequestBodyPublisherReadListener() {
            }

            @Override
            public void onDataAvailable() throws IOException {
                RequestBodyPublisher.this.onDataAvailable();
            }

            @Override
            public void onAllDataRead() throws IOException {
                RequestBodyPublisher.this.onAllDataRead();
            }

            @Override
            public void onError(Throwable throwable) {
                RequestBodyPublisher.this.onError(throwable);
            }
        }
    }

    private final class RequestAsyncListener
    implements AsyncListener {
        private RequestAsyncListener() {
        }

        @Override
        public void onStartAsync(AsyncEvent event) {
        }

        @Override
        public void onTimeout(AsyncEvent event) {
            Throwable ex = event.getThrowable();
            ex = ex != null ? ex : new IllegalStateException("Async operation timeout.");
            ServletServerHttpRequest.this.bodyPublisher.onError(ex);
        }

        @Override
        public void onError(AsyncEvent event) {
            ServletServerHttpRequest.this.bodyPublisher.onError(event.getThrowable());
        }

        @Override
        public void onComplete(AsyncEvent event) {
            ServletServerHttpRequest.this.bodyPublisher.onAllDataRead();
        }
    }
}

