/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.server.reactive;

import com.baidu.cloud.thirdparty.servlet.AsyncContext;
import com.baidu.cloud.thirdparty.servlet.ServletRequest;
import com.baidu.cloud.thirdparty.servlet.ServletResponse;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DataBuffer;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DataBufferFactory;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DataBufferUtils;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.HttpHandler;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServerHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServerHttpResponse;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServletServerHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServletServerHttpResponse;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.apache.catalina.connector.CoyoteInputStream;
import org.apache.catalina.connector.CoyoteOutputStream;

public class TomcatHttpHandlerAdapter
extends ServletHttpHandlerAdapter {
    public TomcatHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    @Override
    protected ServerHttpRequest createRequest(HttpServletRequest request, AsyncContext asyncContext) throws IOException, URISyntaxException {
        Assert.notNull((Object)this.getServletPath(), "servletPath is not initialized.");
        return new TomcatServerHttpRequest(request, asyncContext, this.getServletPath(), this.getDataBufferFactory(), this.getBufferSize());
    }

    @Override
    protected ServerHttpResponse createResponse(HttpServletResponse response, AsyncContext cxt) throws IOException {
        return new TomcatServerHttpResponse(response, cxt, this.getDataBufferFactory(), this.getBufferSize());
    }

    private static final class TomcatServerHttpResponse
    extends ServletServerHttpResponse {
        public TomcatServerHttpResponse(HttpServletResponse response, AsyncContext context, DataBufferFactory factory, int bufferSize) throws IOException {
            super(response, context, factory, bufferSize);
        }

        @Override
        protected int writeToOutputStream(DataBuffer dataBuffer) throws IOException {
            ByteBuffer input = dataBuffer.asByteBuffer();
            int len = input.remaining();
            ServletResponse response = (ServletResponse)this.getNativeResponse();
            ((CoyoteOutputStream)response.getOutputStream()).write(input);
            return len;
        }
    }

    private final class TomcatServerHttpRequest
    extends ServletServerHttpRequest {
        public TomcatServerHttpRequest(HttpServletRequest request, AsyncContext context, String servletPath, DataBufferFactory factory, int bufferSize) throws IOException, URISyntaxException {
            super(request, context, servletPath, factory, bufferSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected DataBuffer readFromInputStream() throws IOException {
            boolean release = true;
            int capacity = TomcatHttpHandlerAdapter.this.getBufferSize();
            DataBuffer dataBuffer = TomcatHttpHandlerAdapter.this.getDataBufferFactory().allocateBuffer(capacity);
            try {
                ByteBuffer byteBuffer = dataBuffer.asByteBuffer(0, capacity);
                ServletRequest request = (ServletRequest)this.getNativeRequest();
                int read = ((CoyoteInputStream)request.getInputStream()).read(byteBuffer);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("read:" + read);
                }
                if (read > 0) {
                    dataBuffer.writePosition(read);
                    release = false;
                    DataBuffer dataBuffer2 = dataBuffer;
                    return dataBuffer2;
                }
                if (read == -1) {
                    DataBuffer dataBuffer3 = EOF_BUFFER;
                    return dataBuffer3;
                }
                DataBuffer dataBuffer4 = null;
                return dataBuffer4;
            }
            finally {
                if (release) {
                    DataBufferUtils.release(dataBuffer);
                }
            }
        }
    }
}

