/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.jmx.access;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.springframework.beans.factory.DisposableBean;
import com.baidu.cloud.thirdparty.springframework.beans.factory.InitializingBean;
import com.baidu.cloud.thirdparty.springframework.jmx.JmxException;
import com.baidu.cloud.thirdparty.springframework.jmx.MBeanServerNotFoundException;
import com.baidu.cloud.thirdparty.springframework.jmx.access.ConnectorDelegate;
import com.baidu.cloud.thirdparty.springframework.jmx.support.NotificationListenerHolder;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;

public class NotificationListenerRegistrar
extends NotificationListenerHolder
implements InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ConnectorDelegate connector = new ConnectorDelegate();
    @Nullable
    private MBeanServerConnection server;
    @Nullable
    private JMXServiceURL serviceUrl;
    @Nullable
    private Map<String, ?> environment;
    @Nullable
    private String agentId;
    @Nullable
    private ObjectName[] actualObjectNames;

    public void setServer(MBeanServerConnection server) {
        this.server = server;
    }

    public void setEnvironment(@Nullable Map<String, ?> environment2) {
        this.environment = environment2;
    }

    @Nullable
    public Map<String, ?> getEnvironment() {
        return this.environment;
    }

    public void setServiceUrl(String url) throws MalformedURLException {
        this.serviceUrl = new JMXServiceURL(url);
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.getNotificationListener() == null) {
            throw new IllegalArgumentException("Property 'notificationListener' is required");
        }
        if (CollectionUtils.isEmpty(this.mappedObjectNames)) {
            throw new IllegalArgumentException("Property 'mappedObjectName' is required");
        }
        this.prepare();
    }

    public void prepare() {
        if (this.server == null) {
            this.server = this.connector.connect(this.serviceUrl, this.environment, this.agentId);
        }
        try {
            this.actualObjectNames = this.getResolvedObjectNames();
            if (this.actualObjectNames != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Registering NotificationListener for MBeans " + Arrays.asList(this.actualObjectNames));
                }
                for (ObjectName actualObjectName : this.actualObjectNames) {
                    this.server.addNotificationListener(actualObjectName, this.getNotificationListener(), this.getNotificationFilter(), this.getHandback());
                }
            }
        }
        catch (IOException ex) {
            throw new MBeanServerNotFoundException("Could not connect to remote MBeanServer at URL [" + this.serviceUrl + "]", ex);
        }
        catch (Exception ex) {
            throw new JmxException("Unable to register NotificationListener", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            if (this.server != null && this.actualObjectNames != null) {
                for (ObjectName actualObjectName : this.actualObjectNames) {
                    try {
                        this.server.removeNotificationListener(actualObjectName, this.getNotificationListener(), this.getNotificationFilter(), this.getHandback());
                    }
                    catch (Exception ex) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("Unable to unregister NotificationListener", ex);
                    }
                }
            }
        }
        finally {
            this.connector.close();
        }
    }
}

