/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.jmx.export.annotation;

import com.baidu.cloud.thirdparty.springframework.beans.BeanUtils;
import com.baidu.cloud.thirdparty.springframework.beans.annotation.AnnotationBeanUtils;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanFactory;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanFactoryAware;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.ConfigurableBeanFactory;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.EmbeddedValueResolver;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationUtils;
import com.baidu.cloud.thirdparty.springframework.jmx.export.annotation.ManagedAttribute;
import com.baidu.cloud.thirdparty.springframework.jmx.export.annotation.ManagedMetric;
import com.baidu.cloud.thirdparty.springframework.jmx.export.annotation.ManagedNotification;
import com.baidu.cloud.thirdparty.springframework.jmx.export.annotation.ManagedNotifications;
import com.baidu.cloud.thirdparty.springframework.jmx.export.annotation.ManagedOperation;
import com.baidu.cloud.thirdparty.springframework.jmx.export.annotation.ManagedOperationParameter;
import com.baidu.cloud.thirdparty.springframework.jmx.export.annotation.ManagedOperationParameters;
import com.baidu.cloud.thirdparty.springframework.jmx.export.annotation.ManagedResource;
import com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.InvalidMetadataException;
import com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.JmxAttributeSource;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.StringValueResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Set;

public class AnnotationJmxAttributeSource
implements JmxAttributeSource,
BeanFactoryAware {
    @Nullable
    private StringValueResolver embeddedValueResolver;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.embeddedValueResolver = new EmbeddedValueResolver((ConfigurableBeanFactory)beanFactory);
        }
    }

    @Override
    @Nullable
    public com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedResource getManagedResource(Class<?> beanClass) throws InvalidMetadataException {
        Class<?> target;
        ManagedResource ann = AnnotationUtils.findAnnotation(beanClass, ManagedResource.class);
        if (ann == null) {
            return null;
        }
        Class<?> declaringClass = AnnotationUtils.findAnnotationDeclaringClass(ManagedResource.class, beanClass);
        Class<?> clazz = target = declaringClass != null && !declaringClass.isInterface() ? declaringClass : beanClass;
        if (!Modifier.isPublic(target.getModifiers())) {
            throw new InvalidMetadataException("@ManagedResource class '" + target.getName() + "' must be public");
        }
        com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedResource managedResource = new com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedResource();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)managedResource, this.embeddedValueResolver, new String[0]);
        return managedResource;
    }

    @Override
    @Nullable
    public com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedAttribute getManagedAttribute(Method method) throws InvalidMetadataException {
        ManagedAttribute ann = AnnotationUtils.findAnnotation(method, ManagedAttribute.class);
        if (ann == null) {
            return null;
        }
        com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedAttribute managedAttribute = new com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedAttribute();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)managedAttribute, "defaultValue");
        if (ann.defaultValue().length() > 0) {
            managedAttribute.setDefaultValue(ann.defaultValue());
        }
        return managedAttribute;
    }

    @Override
    @Nullable
    public com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedMetric getManagedMetric(Method method) throws InvalidMetadataException {
        ManagedMetric ann = AnnotationUtils.findAnnotation(method, ManagedMetric.class);
        return AnnotationJmxAttributeSource.copyPropertiesToBean(ann, com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedMetric.class);
    }

    @Override
    @Nullable
    public com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedOperation getManagedOperation(Method method) throws InvalidMetadataException {
        ManagedOperation ann = AnnotationUtils.findAnnotation(method, ManagedOperation.class);
        return AnnotationJmxAttributeSource.copyPropertiesToBean(ann, com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedOperation.class);
    }

    @Override
    public com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedOperationParameter[] getManagedOperationParameters(Method method) throws InvalidMetadataException {
        Set<ManagedOperationParameter> anns = AnnotationUtils.getRepeatableAnnotations(method, ManagedOperationParameter.class, ManagedOperationParameters.class);
        return AnnotationJmxAttributeSource.copyPropertiesToBeanArray(anns, com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedOperationParameter.class);
    }

    @Override
    public com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedNotification[] getManagedNotifications(Class<?> clazz) throws InvalidMetadataException {
        Set<ManagedNotification> anns = AnnotationUtils.getRepeatableAnnotations(clazz, ManagedNotification.class, ManagedNotifications.class);
        return AnnotationJmxAttributeSource.copyPropertiesToBeanArray(anns, com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedNotification.class);
    }

    private static <T> T[] copyPropertiesToBeanArray(Collection<? extends Annotation> anns, Class<T> beanClass) {
        Object[] beans2 = (Object[])Array.newInstance(beanClass, anns.size());
        int i = 0;
        for (Annotation annotation : anns) {
            beans2[i++] = AnnotationJmxAttributeSource.copyPropertiesToBean(annotation, beanClass);
        }
        return beans2;
    }

    @Nullable
    private static <T> T copyPropertiesToBean(@Nullable Annotation ann, Class<T> beanClass) {
        if (ann == null) {
            return null;
        }
        T bean2 = BeanUtils.instantiateClass(beanClass);
        AnnotationBeanUtils.copyPropertiesToBean(ann, bean2, new String[0]);
        return bean2;
    }
}

