/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.remoting.rmi;

import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.remoting.rmi.RmiBasedExporter;
import com.baidu.cloud.thirdparty.springframework.remoting.rmi.RmiInvocationHandler;
import com.baidu.cloud.thirdparty.springframework.remoting.support.RemoteInvocation;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;

class RmiInvocationWrapper
implements RmiInvocationHandler {
    private final Object wrappedObject;
    private final RmiBasedExporter rmiExporter;

    public RmiInvocationWrapper(Object wrappedObject, RmiBasedExporter rmiExporter) {
        Assert.notNull(wrappedObject, "Object to wrap is required");
        Assert.notNull((Object)rmiExporter, "RMI exporter is required");
        this.wrappedObject = wrappedObject;
        this.rmiExporter = rmiExporter;
    }

    @Override
    @Nullable
    public String getTargetInterfaceName() {
        Class<?> ifc = this.rmiExporter.getServiceInterface();
        return ifc != null ? ifc.getName() : null;
    }

    @Override
    @Nullable
    public Object invoke(RemoteInvocation invocation) throws RemoteException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.rmiExporter.invoke(invocation, this.wrappedObject);
    }
}

