/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.scheduling.concurrent;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.springframework.beans.factory.InitializingBean;
import com.baidu.cloud.thirdparty.springframework.jndi.JndiLocatorDelegate;
import com.baidu.cloud.thirdparty.springframework.jndi.JndiTemplate;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.scheduling.concurrent.CustomizableThreadFactory;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import javax.naming.NamingException;

public class DefaultManagedAwareThreadFactory
extends CustomizableThreadFactory
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JndiLocatorDelegate jndiLocator = new JndiLocatorDelegate();
    @Nullable
    private String jndiName = "java:comp/DefaultManagedThreadFactory";
    @Nullable
    private ThreadFactory threadFactory;

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiLocator.setJndiTemplate(jndiTemplate);
    }

    public void setJndiEnvironment(Properties jndiEnvironment) {
        this.jndiLocator.setJndiEnvironment(jndiEnvironment);
    }

    public void setResourceRef(boolean resourceRef) {
        this.jndiLocator.setResourceRef(resourceRef);
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    @Override
    public void afterPropertiesSet() throws NamingException {
        if (this.jndiName != null) {
            try {
                this.threadFactory = this.jndiLocator.lookup(this.jndiName, ThreadFactory.class);
            }
            catch (NamingException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Failed to retrieve [" + this.jndiName + "] from JNDI", ex);
                }
                this.logger.info("Could not find default managed thread factory in JNDI - proceeding with default local thread factory");
            }
        }
    }

    @Override
    public Thread newThread(Runnable runnable) {
        if (this.threadFactory != null) {
            return this.threadFactory.newThread(runnable);
        }
        return super.newThread(runnable);
    }
}

