/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.scripting.support;

import com.baidu.cloud.thirdparty.springframework.aop.target.dynamic.BeanFactoryRefreshableTargetSource;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanFactory;
import com.baidu.cloud.thirdparty.springframework.scripting.ScriptFactory;
import com.baidu.cloud.thirdparty.springframework.scripting.ScriptSource;
import com.baidu.cloud.thirdparty.springframework.util.Assert;

public class RefreshableScriptTargetSource
extends BeanFactoryRefreshableTargetSource {
    private final ScriptFactory scriptFactory;
    private final ScriptSource scriptSource;
    private final boolean isFactoryBean;

    public RefreshableScriptTargetSource(BeanFactory beanFactory, String beanName, ScriptFactory scriptFactory, ScriptSource scriptSource, boolean isFactoryBean) {
        super(beanFactory, beanName);
        Assert.notNull((Object)scriptFactory, "ScriptFactory must not be null");
        Assert.notNull((Object)scriptSource, "ScriptSource must not be null");
        this.scriptFactory = scriptFactory;
        this.scriptSource = scriptSource;
        this.isFactoryBean = isFactoryBean;
    }

    @Override
    protected boolean requiresRefresh() {
        return this.scriptFactory.requiresScriptedObjectRefresh(this.scriptSource);
    }

    @Override
    protected Object obtainFreshBean(BeanFactory beanFactory, String beanName) {
        return super.obtainFreshBean(beanFactory, this.isFactoryBean ? "&" + beanName : beanName);
    }
}

