/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.util.comparator;

import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.util.Comparator;

public class InstanceComparator<T>
implements Comparator<T> {
    private final Class<?>[] instanceOrder;

    public InstanceComparator(Class<?> ... instanceOrder) {
        Assert.notNull(instanceOrder, "'instanceOrder' array must not be null");
        this.instanceOrder = instanceOrder;
    }

    @Override
    public int compare(T o1, T o2) {
        int i2;
        int i1 = this.getOrder(o1);
        return i1 < (i2 = this.getOrder(o2)) ? -1 : (i1 == i2 ? 0 : 1);
    }

    private int getOrder(@Nullable T object) {
        if (object != null) {
            for (int i = 0; i < this.instanceOrder.length; ++i) {
                if (!this.instanceOrder[i].isInstance(object)) continue;
                return i;
            }
        }
        return this.instanceOrder.length;
    }
}

