/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.validation;

import com.baidu.cloud.thirdparty.springframework.beans.BeanUtils;
import com.baidu.cloud.thirdparty.springframework.beans.ConfigurablePropertyAccessor;
import com.baidu.cloud.thirdparty.springframework.beans.PropertyAccessorUtils;
import com.baidu.cloud.thirdparty.springframework.beans.PropertyEditorRegistry;
import com.baidu.cloud.thirdparty.springframework.core.convert.ConversionService;
import com.baidu.cloud.thirdparty.springframework.core.convert.TypeDescriptor;
import com.baidu.cloud.thirdparty.springframework.core.convert.support.ConvertingPropertyEditorAdapter;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.validation.AbstractBindingResult;
import java.beans.PropertyEditor;

public abstract class AbstractPropertyBindingResult
extends AbstractBindingResult {
    @Nullable
    private transient ConversionService conversionService;

    protected AbstractPropertyBindingResult(String objectName) {
        super(objectName);
    }

    public void initConversion(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, "ConversionService must not be null");
        this.conversionService = conversionService;
        if (this.getTarget() != null) {
            this.getPropertyAccessor().setConversionService(conversionService);
        }
    }

    @Override
    public PropertyEditorRegistry getPropertyEditorRegistry() {
        return this.getTarget() != null ? this.getPropertyAccessor() : null;
    }

    @Override
    protected String canonicalFieldName(String field) {
        return PropertyAccessorUtils.canonicalPropertyName(field);
    }

    @Override
    @Nullable
    public Class<?> getFieldType(@Nullable String field) {
        return this.getTarget() != null ? this.getPropertyAccessor().getPropertyType(this.fixedField(field)) : super.getFieldType(field);
    }

    @Override
    @Nullable
    protected Object getActualFieldValue(String field) {
        return this.getPropertyAccessor().getPropertyValue(field);
    }

    @Override
    protected Object formatFieldValue(String field, @Nullable Object value) {
        String fixedField = this.fixedField(field);
        PropertyEditor customEditor = this.getCustomEditor(fixedField);
        if (customEditor != null) {
            customEditor.setValue(value);
            String textValue = customEditor.getAsText();
            if (textValue != null) {
                return textValue;
            }
        }
        if (this.conversionService != null) {
            TypeDescriptor fieldDesc = this.getPropertyAccessor().getPropertyTypeDescriptor(fixedField);
            TypeDescriptor strDesc = TypeDescriptor.valueOf(String.class);
            if (fieldDesc != null && this.conversionService.canConvert(fieldDesc, strDesc)) {
                return this.conversionService.convert(value, fieldDesc, strDesc);
            }
        }
        return value;
    }

    @Nullable
    protected PropertyEditor getCustomEditor(String fixedField) {
        Class<?> targetType = this.getPropertyAccessor().getPropertyType(fixedField);
        PropertyEditor editor = this.getPropertyAccessor().findCustomEditor(targetType, fixedField);
        if (editor == null) {
            editor = BeanUtils.findEditorByConvention(targetType);
        }
        return editor;
    }

    @Override
    @Nullable
    public PropertyEditor findEditor(@Nullable String field, @Nullable Class<?> valueType) {
        PropertyEditor editor;
        Class<?> valueTypeForLookup = valueType;
        if (valueTypeForLookup == null) {
            valueTypeForLookup = this.getFieldType(field);
        }
        if ((editor = super.findEditor(field, valueTypeForLookup)) == null && this.conversionService != null) {
            TypeDescriptor ptd;
            TypeDescriptor td = null;
            if (field != null && this.getTarget() != null && (ptd = this.getPropertyAccessor().getPropertyTypeDescriptor(this.fixedField(field))) != null && (valueType == null || valueType.isAssignableFrom(ptd.getType()))) {
                td = ptd;
            }
            if (td == null) {
                td = TypeDescriptor.valueOf(valueTypeForLookup);
            }
            if (this.conversionService.canConvert(TypeDescriptor.valueOf(String.class), td)) {
                editor = new ConvertingPropertyEditorAdapter(this.conversionService, td);
            }
        }
        return editor;
    }

    public abstract ConfigurablePropertyAccessor getPropertyAccessor();
}

