/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.accept;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.springframework.http.MediaType;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.accept.ContentNegotiationStrategy;
import com.baidu.cloud.thirdparty.springframework.web.context.request.NativeWebRequest;
import java.util.Collections;
import java.util.List;

public class FixedContentNegotiationStrategy
implements ContentNegotiationStrategy {
    private static final Log logger = LogFactory.getLog(FixedContentNegotiationStrategy.class);
    private final List<MediaType> contentTypes;

    public FixedContentNegotiationStrategy(MediaType contentType) {
        this(Collections.singletonList(contentType));
    }

    public FixedContentNegotiationStrategy(List<MediaType> contentTypes) {
        Assert.notNull(contentTypes, "'contentTypes' must not be null");
        this.contentTypes = Collections.unmodifiableList(contentTypes);
    }

    public List<MediaType> getContentTypes() {
        return this.contentTypes;
    }

    @Override
    public List<MediaType> resolveMediaTypes(NativeWebRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug("Requested media types: " + this.contentTypes);
        }
        return this.contentTypes;
    }
}

