/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.bind.support;

import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.Part;
import com.baidu.cloud.thirdparty.springframework.beans.MutablePropertyValues;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.LinkedMultiValueMap;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.validation.BindException;
import com.baidu.cloud.thirdparty.springframework.web.bind.WebDataBinder;
import com.baidu.cloud.thirdparty.springframework.web.context.request.NativeWebRequest;
import com.baidu.cloud.thirdparty.springframework.web.context.request.WebRequest;
import com.baidu.cloud.thirdparty.springframework.web.multipart.MultipartException;
import com.baidu.cloud.thirdparty.springframework.web.multipart.MultipartRequest;

public class WebRequestDataBinder
extends WebDataBinder {
    public WebRequestDataBinder(@Nullable Object target) {
        super(target);
    }

    public WebRequestDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    public void bind(WebRequest request) {
        MutablePropertyValues mpvs = new MutablePropertyValues(request.getParameterMap());
        if (this.isMultipartRequest(request) && request instanceof NativeWebRequest) {
            MultipartRequest multipartRequest = ((NativeWebRequest)request).getNativeRequest(MultipartRequest.class);
            if (multipartRequest != null) {
                this.bindMultipart(multipartRequest.getMultiFileMap(), mpvs);
            } else {
                HttpServletRequest servletRequest = ((NativeWebRequest)request).getNativeRequest(HttpServletRequest.class);
                if (servletRequest != null) {
                    this.bindParts(servletRequest, mpvs);
                }
            }
        }
        this.doBind(mpvs);
    }

    private boolean isMultipartRequest(WebRequest request) {
        String contentType = request.getHeader("Content-Type");
        return contentType != null && StringUtils.startsWithIgnoreCase(contentType, "multipart");
    }

    private void bindParts(HttpServletRequest request, MutablePropertyValues mpvs) {
        try {
            LinkedMultiValueMap<String, Object> map = new LinkedMultiValueMap<String, Object>();
            for (Part part : request.getParts()) {
                map.add(part.getName(), part);
            }
            map.forEach((key, values) -> {
                if (values.size() == 1) {
                    Part part = (Part)values.get(0);
                    if (this.isBindEmptyMultipartFiles() || part.getSize() > 0L) {
                        mpvs.add((String)key, part);
                    }
                } else {
                    mpvs.add((String)key, values);
                }
            });
        }
        catch (Exception ex) {
            throw new MultipartException("Failed to get request parts", ex);
        }
    }

    public void closeNoCatch() throws BindException {
        if (this.getBindingResult().hasErrors()) {
            throw new BindException(this.getBindingResult());
        }
    }
}

