/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.context.request;

import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.web.context.request.RequestAttributes;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractRequestAttributes
implements RequestAttributes {
    protected final Map<String, Runnable> requestDestructionCallbacks = new LinkedHashMap<String, Runnable>(8);
    private volatile boolean requestActive = true;

    public void requestCompleted() {
        this.executeRequestDestructionCallbacks();
        this.updateAccessedSessionAttributes();
        this.requestActive = false;
    }

    protected final boolean isRequestActive() {
        return this.requestActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void registerRequestDestructionCallback(String name, Runnable callback) {
        Assert.notNull((Object)name, "Name must not be null");
        Assert.notNull((Object)callback, "Callback must not be null");
        Map<String, Runnable> map = this.requestDestructionCallbacks;
        synchronized (map) {
            this.requestDestructionCallbacks.put(name, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeRequestDestructionCallback(String name) {
        Assert.notNull((Object)name, "Name must not be null");
        Map<String, Runnable> map = this.requestDestructionCallbacks;
        synchronized (map) {
            this.requestDestructionCallbacks.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequestDestructionCallbacks() {
        Map<String, Runnable> map = this.requestDestructionCallbacks;
        synchronized (map) {
            for (Runnable runnable : this.requestDestructionCallbacks.values()) {
                runnable.run();
            }
            this.requestDestructionCallbacks.clear();
        }
    }

    protected abstract void updateAccessedSessionAttributes();
}

