/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.context.support;

import com.baidu.cloud.thirdparty.servlet.ServletConfig;
import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.DefaultListableBeanFactory;
import com.baidu.cloud.thirdparty.springframework.context.support.GenericApplicationContext;
import com.baidu.cloud.thirdparty.springframework.core.env.ConfigurableEnvironment;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.core.io.support.ResourcePatternResolver;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.ui.context.Theme;
import com.baidu.cloud.thirdparty.springframework.ui.context.ThemeSource;
import com.baidu.cloud.thirdparty.springframework.ui.context.support.UiApplicationContextUtils;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ObjectUtils;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.context.ConfigurableWebApplicationContext;
import com.baidu.cloud.thirdparty.springframework.web.context.ConfigurableWebEnvironment;
import com.baidu.cloud.thirdparty.springframework.web.context.ServletContextAware;
import com.baidu.cloud.thirdparty.springframework.web.context.support.ServletContextAwareProcessor;
import com.baidu.cloud.thirdparty.springframework.web.context.support.ServletContextResource;
import com.baidu.cloud.thirdparty.springframework.web.context.support.ServletContextResourcePatternResolver;
import com.baidu.cloud.thirdparty.springframework.web.context.support.StandardServletEnvironment;
import com.baidu.cloud.thirdparty.springframework.web.context.support.WebApplicationContextUtils;

public class GenericWebApplicationContext
extends GenericApplicationContext
implements ConfigurableWebApplicationContext,
ThemeSource {
    @Nullable
    private ServletContext servletContext;
    @Nullable
    private ThemeSource themeSource;

    public GenericWebApplicationContext() {
    }

    public GenericWebApplicationContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public GenericWebApplicationContext(DefaultListableBeanFactory beanFactory) {
        super(beanFactory);
    }

    public GenericWebApplicationContext(DefaultListableBeanFactory beanFactory, ServletContext servletContext) {
        super(beanFactory);
        this.servletContext = servletContext;
    }

    @Override
    public void setServletContext(@Nullable ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    @Nullable
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public String getApplicationName() {
        return this.servletContext != null ? this.servletContext.getContextPath() : "";
    }

    @Override
    protected ConfigurableEnvironment createEnvironment() {
        return new StandardServletEnvironment();
    }

    @Override
    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        if (this.servletContext != null) {
            beanFactory.addBeanPostProcessor(new ServletContextAwareProcessor(this.servletContext));
            beanFactory.ignoreDependencyInterface(ServletContextAware.class);
        }
        WebApplicationContextUtils.registerWebApplicationScopes(beanFactory, this.servletContext);
        WebApplicationContextUtils.registerEnvironmentBeans(beanFactory, this.servletContext);
    }

    @Override
    protected Resource getResourceByPath(String path) {
        Assert.state(this.servletContext != null, "No ServletContext available");
        return new ServletContextResource(this.servletContext, path);
    }

    @Override
    protected ResourcePatternResolver getResourcePatternResolver() {
        return new ServletContextResourcePatternResolver(this);
    }

    @Override
    protected void onRefresh() {
        this.themeSource = UiApplicationContextUtils.initThemeSource(this);
    }

    @Override
    protected void initPropertySources() {
        ConfigurableEnvironment env = this.getEnvironment();
        if (env instanceof ConfigurableWebEnvironment) {
            ((ConfigurableWebEnvironment)env).initPropertySources(this.servletContext, null);
        }
    }

    @Override
    @Nullable
    public Theme getTheme(String themeName) {
        Assert.state(this.themeSource != null, "No ThemeSource available");
        return this.themeSource.getTheme(themeName);
    }

    @Override
    public void setServletConfig(@Nullable ServletConfig servletConfig) {
    }

    @Override
    @Nullable
    public ServletConfig getServletConfig() {
        throw new UnsupportedOperationException("GenericWebApplicationContext does not support getServletConfig()");
    }

    @Override
    public void setNamespace(@Nullable String namespace) {
    }

    @Override
    @Nullable
    public String getNamespace() {
        throw new UnsupportedOperationException("GenericWebApplicationContext does not support getNamespace()");
    }

    @Override
    public void setConfigLocation(String configLocation) {
        if (StringUtils.hasText(configLocation)) {
            throw new UnsupportedOperationException("GenericWebApplicationContext does not support setConfigLocation(). Do you still have an 'contextConfigLocations' init-param set?");
        }
    }

    @Override
    public void setConfigLocations(String ... configLocations) {
        if (!ObjectUtils.isEmpty(configLocations)) {
            throw new UnsupportedOperationException("GenericWebApplicationContext does not support setConfigLocations(). Do you still have an 'contextConfigLocations' init-param set?");
        }
    }

    @Override
    public String[] getConfigLocations() {
        throw new UnsupportedOperationException("GenericWebApplicationContext does not support getConfigLocations()");
    }
}

