/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.context.support;

import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.springframework.context.ConfigurableApplicationContext;
import com.baidu.cloud.thirdparty.springframework.context.support.LiveBeansView;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;

public class ServletContextLiveBeansView
extends LiveBeansView {
    private final ServletContext servletContext;

    public ServletContextLiveBeansView(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, "ServletContext must not be null");
        this.servletContext = servletContext;
    }

    @Override
    protected Set<ConfigurableApplicationContext> findApplicationContexts() {
        LinkedHashSet<ConfigurableApplicationContext> contexts = new LinkedHashSet<ConfigurableApplicationContext>();
        Enumeration<String> attrNames = this.servletContext.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = attrNames.nextElement();
            Object attrValue = this.servletContext.getAttribute(attrName);
            if (!(attrValue instanceof ConfigurableApplicationContext)) continue;
            contexts.add((ConfigurableApplicationContext)attrValue);
        }
        return contexts;
    }
}

