/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.context.support;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;
import com.baidu.cloud.thirdparty.springframework.web.context.ContextLoader;
import com.baidu.cloud.thirdparty.springframework.web.context.WebApplicationContext;
import com.baidu.cloud.thirdparty.springframework.web.context.support.WebApplicationContextUtils;

public abstract class SpringBeanAutowiringSupport {
    private static final Log logger = LogFactory.getLog(SpringBeanAutowiringSupport.class);

    public SpringBeanAutowiringSupport() {
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
    }

    public static void processInjectionBasedOnCurrentContext(Object target) {
        Assert.notNull(target, "Target object must not be null");
        WebApplicationContext cc = ContextLoader.getCurrentWebApplicationContext();
        if (cc != null) {
            AutowiredAnnotationBeanPostProcessor bpp = new AutowiredAnnotationBeanPostProcessor();
            bpp.setBeanFactory(cc.getAutowireCapableBeanFactory());
            bpp.processInjection(target);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Current WebApplicationContext is not available for processing of " + ClassUtils.getShortName(target.getClass()) + ": Make sure this class gets constructed in a Spring web application. Proceeding without injection.");
        }
    }

    public static void processInjectionBasedOnServletContext(Object target, ServletContext servletContext) {
        Assert.notNull(target, "Target object must not be null");
        WebApplicationContext cc = WebApplicationContextUtils.getRequiredWebApplicationContext(servletContext);
        AutowiredAnnotationBeanPostProcessor bpp = new AutowiredAnnotationBeanPostProcessor();
        bpp.setBeanFactory(cc.getAutowireCapableBeanFactory());
        bpp.processInjection(target);
    }
}

