/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.filter;

import com.baidu.cloud.thirdparty.servlet.FilterChain;
import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequestWrapper;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponseWrapper;
import com.baidu.cloud.thirdparty.springframework.http.HttpStatus;
import com.baidu.cloud.thirdparty.springframework.http.server.ServletServerHttpRequest;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import com.baidu.cloud.thirdparty.springframework.util.LinkedCaseInsensitiveMap;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import com.baidu.cloud.thirdparty.springframework.web.filter.OncePerRequestFilter;
import com.baidu.cloud.thirdparty.springframework.web.filter.RelativeRedirectResponseWrapper;
import com.baidu.cloud.thirdparty.springframework.web.util.UriComponents;
import com.baidu.cloud.thirdparty.springframework.web.util.UriComponentsBuilder;
import com.baidu.cloud.thirdparty.springframework.web.util.UrlPathHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ForwardedHeaderFilter
extends OncePerRequestFilter {
    private static final Set<String> FORWARDED_HEADER_NAMES = Collections.newSetFromMap(new LinkedCaseInsensitiveMap<Boolean>(5, Locale.ENGLISH));
    private final UrlPathHelper pathHelper = new UrlPathHelper();
    private boolean removeOnly;
    private boolean relativeRedirects;

    public ForwardedHeaderFilter() {
        this.pathHelper.setUrlDecode(false);
        this.pathHelper.setRemoveSemicolonContent(false);
    }

    public void setRemoveOnly(boolean removeOnly) {
        this.removeOnly = removeOnly;
    }

    public void setRelativeRedirects(boolean relativeRedirects) {
        this.relativeRedirects = relativeRedirects;
    }

    @Override
    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        for (String headerName : FORWARDED_HEADER_NAMES) {
            if (request.getHeader(headerName) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    @Override
    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.removeOnly) {
            ForwardedHeaderRemovingRequest theRequest = new ForwardedHeaderRemovingRequest(request);
            filterChain.doFilter(theRequest, response);
        } else {
            ForwardedHeaderExtractingRequest theRequest = new ForwardedHeaderExtractingRequest(request, this.pathHelper);
            HttpServletResponse theResponse = this.relativeRedirects ? RelativeRedirectResponseWrapper.wrapIfNecessary(response, HttpStatus.SEE_OTHER) : new ForwardedHeaderExtractingResponse(response, theRequest);
            filterChain.doFilter(theRequest, theResponse);
        }
    }

    static {
        FORWARDED_HEADER_NAMES.add("Forwarded");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Host");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Port");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Proto");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Prefix");
    }

    private static class ForwardedHeaderExtractingResponse
    extends HttpServletResponseWrapper {
        private static final String FOLDER_SEPARATOR = "/";
        private final HttpServletRequest request;

        public ForwardedHeaderExtractingResponse(HttpServletResponse response, HttpServletRequest request) {
            super(response);
            this.request = request;
        }

        @Override
        public void sendRedirect(String location) throws IOException {
            UriComponentsBuilder builder = UriComponentsBuilder.fromUriString(location);
            UriComponents uriComponents = builder.build();
            if (uriComponents.getScheme() != null) {
                super.sendRedirect(location);
                return;
            }
            if (location.startsWith("//")) {
                String scheme = this.request.getScheme();
                super.sendRedirect(builder.scheme(scheme).toUriString());
                return;
            }
            String path = uriComponents.getPath();
            if (path != null) {
                path = path.startsWith(FOLDER_SEPARATOR) ? path : StringUtils.applyRelativePath(this.request.getRequestURI(), path);
            }
            String result = UriComponentsBuilder.fromHttpRequest(new ServletServerHttpRequest(this.request)).replacePath(path).replaceQuery(uriComponents.getQuery()).fragment(uriComponents.getFragment()).build().normalize().toUriString();
            super.sendRedirect(result);
        }
    }

    private static class ForwardedHeaderExtractingRequest
    extends ForwardedHeaderRemovingRequest {
        @Nullable
        private final String scheme;
        private final boolean secure;
        @Nullable
        private final String host;
        private final int port;
        private final String contextPath;
        private final String requestUri;
        private final String requestUrl;

        public ForwardedHeaderExtractingRequest(HttpServletRequest request, UrlPathHelper pathHelper) {
            super(request);
            ServletServerHttpRequest httpRequest = new ServletServerHttpRequest(request);
            UriComponents uriComponents = UriComponentsBuilder.fromHttpRequest(httpRequest).build();
            int port = uriComponents.getPort();
            this.scheme = uriComponents.getScheme();
            this.secure = "https".equals(this.scheme);
            this.host = uriComponents.getHost();
            this.port = port == -1 ? (this.secure ? 443 : 80) : port;
            String prefix = ForwardedHeaderExtractingRequest.getForwardedPrefix(request);
            this.contextPath = prefix != null ? prefix : request.getContextPath();
            this.requestUri = this.contextPath + pathHelper.getPathWithinApplication(request);
            this.requestUrl = this.scheme + "://" + this.host + (port == -1 ? "" : ":" + port) + this.requestUri;
        }

        @Nullable
        private static String getForwardedPrefix(HttpServletRequest request) {
            String prefix = null;
            Enumeration<String> names = request.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                if (!"X-Forwarded-Prefix".equalsIgnoreCase(name)) continue;
                prefix = request.getHeader(name);
            }
            if (prefix != null) {
                while (prefix.endsWith("/")) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                }
            }
            return prefix;
        }

        @Override
        @Nullable
        public String getScheme() {
            return this.scheme;
        }

        @Override
        @Nullable
        public String getServerName() {
            return this.host;
        }

        @Override
        public int getServerPort() {
            return this.port;
        }

        @Override
        public boolean isSecure() {
            return this.secure;
        }

        @Override
        public String getContextPath() {
            return this.contextPath;
        }

        @Override
        public String getRequestURI() {
            return this.requestUri;
        }

        @Override
        public StringBuffer getRequestURL() {
            return new StringBuffer(this.requestUrl);
        }
    }

    private static class ForwardedHeaderRemovingRequest
    extends HttpServletRequestWrapper {
        private final Map<String, List<String>> headers;

        public ForwardedHeaderRemovingRequest(HttpServletRequest request) {
            super(request);
            this.headers = ForwardedHeaderRemovingRequest.initHeaders(request);
        }

        private static Map<String, List<String>> initHeaders(HttpServletRequest request) {
            LinkedCaseInsensitiveMap<List<String>> headers = new LinkedCaseInsensitiveMap<List<String>>(Locale.ENGLISH);
            Enumeration<String> names = request.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                if (FORWARDED_HEADER_NAMES.contains(name)) continue;
                headers.put(name, (List<String>)Collections.list(request.getHeaders(name)));
            }
            return headers;
        }

        @Override
        @Nullable
        public String getHeader(String name) {
            List<String> value = this.headers.get(name);
            return CollectionUtils.isEmpty(value) ? null : value.get(0);
        }

        @Override
        public Enumeration<String> getHeaders(String name) {
            List<String> value = this.headers.get(name);
            return Collections.enumeration(value != null ? value : Collections.emptySet());
        }

        @Override
        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(this.headers.keySet());
        }
    }
}

