/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.web.method.annotation;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.springframework.core.MethodParameter;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;
import com.baidu.cloud.thirdparty.springframework.web.bind.support.WebArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.bind.support.WebDataBinderFactory;
import com.baidu.cloud.thirdparty.springframework.web.context.request.NativeWebRequest;
import com.baidu.cloud.thirdparty.springframework.web.method.support.HandlerMethodArgumentResolver;
import com.baidu.cloud.thirdparty.springframework.web.method.support.ModelAndViewContainer;

public abstract class AbstractWebArgumentResolverAdapter
implements HandlerMethodArgumentResolver {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final WebArgumentResolver adaptee;

    public AbstractWebArgumentResolverAdapter(WebArgumentResolver adaptee) {
        Assert.notNull((Object)adaptee, "'adaptee' must not be null");
        this.adaptee = adaptee;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        try {
            NativeWebRequest webRequest = this.getWebRequest();
            Object result = this.adaptee.resolveArgument(parameter, webRequest);
            if (result == WebArgumentResolver.UNRESOLVED) {
                return false;
            }
            return ClassUtils.isAssignableValue(parameter.getParameterType(), result);
        }
        catch (Exception ex) {
            this.logger.debug("Error in checking support for parameter [" + parameter + "], message: " + ex.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        Class<?> paramType = parameter.getParameterType();
        Object result = this.adaptee.resolveArgument(parameter, webRequest);
        if (result == WebArgumentResolver.UNRESOLVED || !ClassUtils.isAssignableValue(paramType, result)) {
            throw new IllegalStateException("Standard argument type [" + paramType.getName() + "] in method " + parameter.getMethod() + "resolved to incompatible value of type [" + (result != null ? result.getClass() : null) + "]. Consider declaring the argument type in a less specific fashion.");
        }
        return result;
    }

    protected abstract NativeWebRequest getWebRequest();
}

